/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.closure.Closure;
import org.springframework.core.closure.Constraint;
import org.springframework.core.closure.support.Algorithms;
import org.springframework.core.closure.support.Block;
import org.springframework.core.style.ToStringCreator;
import org.springframework.rules.constraint.AbstractConstraint;
import org.springframework.util.Assert;

public abstract class CompoundConstraint
extends AbstractConstraint {
    private List constraints = new ArrayList();

    public CompoundConstraint() {
    }

    public CompoundConstraint(Constraint constraint1, Constraint constraint2) {
        Assert.isTrue((constraint1 != null && constraint2 != null ? 1 : 0) != 0, (String)"Both constraints are required");
        this.constraints.add(constraint1);
        this.constraints.add(constraint2);
    }

    public CompoundConstraint(Constraint[] constraints) {
        this.constraints.addAll(Arrays.asList(constraints));
    }

    public CompoundConstraint add(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public CompoundConstraint addAll(List constraints) {
        Algorithms.instance().forEach((Collection)constraints, (Closure)new Block(){

            protected void handle(Object o) {
                CompoundConstraint.this.add((Constraint)o);
            }
        });
        return this;
    }

    public void remove(Constraint constraint) {
        this.constraints.remove(constraint);
    }

    public int indexOf(Constraint child) {
        return this.constraints.indexOf(child);
    }

    public Constraint get(int index) {
        return (Constraint)this.constraints.get(index);
    }

    public void copyInto(CompoundConstraint p) {
        p.constraints.clear();
        p.constraints.addAll(this.constraints);
    }

    public void set(int index, Constraint constraint) {
        this.constraints.set(index, constraint);
    }

    public Iterator iterator() {
        return this.constraints.iterator();
    }

    public int size() {
        return this.constraints.size();
    }

    public abstract boolean test(Object var1);

    public void validateTypeSafety(final Class constraintType) {
        Assert.notNull((Object)constraintType, (String)"Constraint type is required");
        Assert.isTrue((boolean)Constraint.class.isAssignableFrom(constraintType), (String)"Argument must be a specialization of the Constraint interface");
        boolean result = new AbstractConstraint(){

            public boolean test(Object o) {
                return constraintType.isAssignableFrom(o.getClass());
            }
        }.allTrue(this.iterator());
        Assert.isTrue((boolean)result, (String)("One or more of the aggregated constraints is not assignable to " + constraintType));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("constraints", (Object)this.constraints).toString();
    }
}

