/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import java.lang.reflect.Method;
import org.springframework.core.closure.Constraint;
import org.springframework.rules.reporting.TypeResolvable;
import org.springframework.util.Assert;

public class MethodInvokingConstraint
implements Constraint,
TypeResolvable {
    private Object targetObject;
    private Method testMethod;
    private String type;

    public MethodInvokingConstraint(Object targetObject, String methodName) {
        this(targetObject, methodName, null, null);
    }

    public MethodInvokingConstraint(Object targetObject, String methodName, String constraintType) {
        this(targetObject, methodName, null, constraintType);
    }

    private Class guessParameterType(Object object, String methodName) {
        Method[] methods = this.targetObject.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] types;
            Method m = methods[i];
            if (!m.getName().equals(methodName) || (types = m.getParameterTypes()).length != 1) continue;
            return types[0];
        }
        throw new IllegalArgumentException("No single argument, boolean method found with name '" + methodName + "'");
    }

    public MethodInvokingConstraint(Object targetObject, String methodName, Class parameterType) {
        this(targetObject, methodName, parameterType, null);
    }

    public MethodInvokingConstraint(Object targetObject, String methodName, Class parameterType, String constraintType) {
        Assert.notNull((Object)targetObject, (String)"targetObject is required");
        this.targetObject = targetObject;
        if (parameterType == null) {
            parameterType = this.guessParameterType(targetObject, methodName);
        }
        this.setType(constraintType);
        try {
            this.testMethod = targetObject.getClass().getMethod(methodName, parameterType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        Class<?> returnType = this.testMethod.getReturnType();
        Assert.isTrue((returnType == Boolean.class || returnType == Boolean.TYPE ? 1 : 0) != 0, (String)"Return type must be a boolean type");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean test(Object argument) {
        try {
            return (Boolean)this.testMethod.invoke(this.targetObject, argument);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

