/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.closure.Constraint;
import org.springframework.rules.reporting.TypeResolvableSupport;

public class RegexpConstraint
extends TypeResolvableSupport
implements Constraint {
    private Pattern pattern;

    public RegexpConstraint(String regex) {
        this(regex, null);
    }

    public RegexpConstraint(String regex, String type) {
        super(type);
        this.pattern = Pattern.compile(regex);
    }

    public boolean test(Object argument) {
        if (argument == null) {
            argument = "";
        }
        Matcher m = this.pattern.matcher((CharSequence)argument);
        return m.matches();
    }

    public String toString() {
        return this.getDefaultMessage() + " " + this.pattern.pattern();
    }
}

