/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import java.util.Collection;
import java.util.Map;
import org.springframework.core.closure.Constraint;
import org.springframework.rules.reporting.TypeResolvable;
import org.springframework.util.StringUtils;

public class Required
implements Constraint,
TypeResolvable {
    private static final Required required = new Required();
    private static final Required present = new Required("present");
    private final String type;

    public Required(String type) {
        this.type = type;
    }

    public Required() {
        this("required");
    }

    public boolean test(Object argument) {
        if (argument != null) {
            if (argument instanceof String) {
                if (StringUtils.hasText((String)((String)argument))) {
                    return true;
                }
            } else {
                if (argument instanceof Collection) {
                    return !((Collection)argument).isEmpty();
                }
                if (argument instanceof Map) {
                    return !((Map)argument).isEmpty();
                }
                if (argument.getClass().isArray()) {
                    return ((Object[])argument).length > 0;
                }
                return true;
            }
        }
        return false;
    }

    public static Required instance() {
        return required;
    }

    public static Required present() {
        return present;
    }

    public String toString() {
        return this.getType();
    }

    public String getType() {
        return this.type;
    }
}

