/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.rules.constraint.property.AbstractPropertyConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.reporting.TypeResolvable;
import org.springframework.util.Assert;

public class ConditionalPropertyConstraint
extends AbstractPropertyConstraint
implements TypeResolvable {
    private final PropertyConstraint ifConstraint;
    private final PropertyConstraint thenConstraint;
    private final PropertyConstraint elseConstraint;
    private String type;

    public ConditionalPropertyConstraint(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint) {
        this(ifConstraint, thenConstraint, null, null);
    }

    public ConditionalPropertyConstraint(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint, String type) {
        this(ifConstraint, thenConstraint, null, type);
    }

    public ConditionalPropertyConstraint(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint, PropertyConstraint elseConstraint) {
        this(ifConstraint, thenConstraint, elseConstraint, null);
    }

    public ConditionalPropertyConstraint(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint, PropertyConstraint elseConstraint, String type) {
        super(ifConstraint.getPropertyName());
        Assert.notNull((Object)ifConstraint);
        Assert.notNull((Object)thenConstraint);
        this.ifConstraint = ifConstraint;
        this.thenConstraint = thenConstraint;
        this.elseConstraint = elseConstraint;
        this.type = type;
    }

    public boolean isCompoundRule() {
        return true;
    }

    public boolean isDependentOn(String propertyName) {
        if (this.elseConstraint == null) {
            return this.ifConstraint.isDependentOn(propertyName) || this.thenConstraint.isDependentOn(propertyName);
        }
        return this.ifConstraint.isDependentOn(propertyName) || this.thenConstraint.isDependentOn(propertyName) || this.elseConstraint.isDependentOn(propertyName);
    }

    protected boolean test(PropertyAccessStrategy domainObjectAccessStrategy) {
        if (this.ifConstraint.test(domainObjectAccessStrategy)) {
            return this.thenConstraint.test(domainObjectAccessStrategy);
        }
        if (this.elseConstraint != null) {
            return this.elseConstraint.test(domainObjectAccessStrategy);
        }
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

