/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import org.springframework.core.closure.Constraint;
import org.springframework.rules.closure.BinaryConstraint;
import org.springframework.rules.constraint.ParameterizedBinaryConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.constraint.property.PropertyValueConstraint;

public class ParameterizedPropertyConstraint
implements PropertyConstraint {
    private PropertyValueConstraint parameterizedExpression;

    public ParameterizedPropertyConstraint(String propertyName, BinaryConstraint expression, Object parameter) {
        this(propertyName, new ParameterizedBinaryConstraint(expression, parameter));
    }

    public ParameterizedPropertyConstraint(String propertyName, Constraint parameterizedExpression) {
        this.parameterizedExpression = new PropertyValueConstraint(propertyName, parameterizedExpression);
    }

    public String getPropertyName() {
        return this.parameterizedExpression.getPropertyName();
    }

    public boolean isDependentOn(String propertyName) {
        return this.parameterizedExpression.isDependentOn(propertyName);
    }

    public boolean isCompoundRule() {
        return this.parameterizedExpression.isCompoundRule();
    }

    public BinaryConstraint getConstraint() {
        return this.getParameterizedBinaryConstraint().getConstraint();
    }

    public Object getParameter() {
        return this.getParameterizedBinaryConstraint().getParameter();
    }

    private ParameterizedBinaryConstraint getParameterizedBinaryConstraint() {
        return (ParameterizedBinaryConstraint)this.parameterizedExpression.getConstraint();
    }

    public boolean test(Object bean) {
        return this.parameterizedExpression.test(bean);
    }

    public String toString() {
        return this.getPropertyName() + " " + this.parameterizedExpression.toString();
    }
}

