/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.factory;

import org.springframework.core.closure.Closure;
import org.springframework.core.closure.Constraint;
import org.springframework.core.closure.support.AlgorithmsAccessor;
import org.springframework.core.closure.support.ClosureChain;
import org.springframework.core.closure.support.IfBlock;
import org.springframework.util.Assert;

public class Closures
extends AlgorithmsAccessor {
    private static Closures INSTANCE = new Closures();

    public static Closures instance() {
        return INSTANCE;
    }

    public static void load(Closures sharedInstance) {
        Assert.notNull((Object)((Object)sharedInstance), (String)"The global closures factory cannot be null");
        INSTANCE = sharedInstance;
    }

    public Closure chain(Closure firstFunction, Closure secondFunction) {
        return new ClosureChain(firstFunction, secondFunction);
    }

    public Closure chain(Closure[] functionsToChain) {
        return new ClosureChain(functionsToChain);
    }

    public Closure ifTrue(Constraint constraint, Closure closure) {
        return new IfBlock(constraint, closure);
    }
}

