/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.reporting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.core.closure.Constraint;
import org.springframework.core.style.StylerUtils;
import org.springframework.rules.constraint.ClosureResultConstraint;
import org.springframework.rules.constraint.CompoundConstraint;
import org.springframework.rules.constraint.Not;
import org.springframework.rules.constraint.ParameterizedBinaryConstraint;
import org.springframework.rules.constraint.Range;
import org.springframework.rules.constraint.StringLengthConstraint;
import org.springframework.rules.constraint.property.CompoundPropertyConstraint;
import org.springframework.rules.constraint.property.ParameterizedPropertyConstraint;
import org.springframework.rules.constraint.property.PropertiesConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.constraint.property.PropertyValueConstraint;
import org.springframework.rules.reporting.DefaultBeanPropertyNameRenderer;
import org.springframework.rules.reporting.MessageTranslator;
import org.springframework.rules.reporting.ObjectNameResolver;
import org.springframework.rules.reporting.PropertyResults;
import org.springframework.rules.reporting.TypeResolvable;
import org.springframework.rules.reporting.ValidationResults;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultMessageTranslator
implements MessageTranslator,
ObjectNameResolver {
    protected static final Log logger = LogFactory.getLog((Class)DefaultMessageTranslator.class);
    private ReflectiveVisitorHelper visitorSupport = new ReflectiveVisitorHelper();
    private List args = new ArrayList();
    private MessageSource messages;
    private ObjectNameResolver objectNameResolver;
    private Locale locale;

    public DefaultMessageTranslator(MessageSource messages) {
        this(messages, null);
    }

    public DefaultMessageTranslator(MessageSource messages, ObjectNameResolver objectNameResolver) {
        this(messages, objectNameResolver, null);
    }

    public DefaultMessageTranslator(MessageSource messages, ObjectNameResolver objectNameResolver, Locale locale) {
        this.setMessageSource(messages);
        this.objectNameResolver = objectNameResolver;
        this.locale = locale;
    }

    public void setMessageSource(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, (String)"messageSource is required");
        this.messages = messageSource;
    }

    public String getMessage(Constraint constraint) {
        String objectName = null;
        if (constraint instanceof PropertyConstraint) {
            objectName = ((PropertyConstraint)constraint).getPropertyName();
        }
        String message = this.buildMessage(objectName, null, constraint);
        return message;
    }

    public String getMessage(String objectName, Constraint constraint) {
        return this.buildMessage(objectName, null, constraint);
    }

    public String getMessage(String objectName, Object rejectedValue, Constraint constraint) {
        return this.buildMessage(objectName, rejectedValue, constraint);
    }

    public String getMessage(String objectName, ValidationResults results) {
        return this.buildMessage(objectName, results.getRejectedValue(), results.getViolatedConstraint());
    }

    public String getMessage(PropertyResults results) {
        Assert.notNull((Object)results, (String)"No property results specified");
        return this.buildMessage(results.getPropertyName(), results.getRejectedValue(), results.getViolatedConstraint());
    }

    private String buildMessage(String objectName, Object rejectedValue, Constraint constraint) {
        StringBuffer buf = new StringBuffer(255);
        MessageSourceResolvable[] args = this.resolveArguments(constraint);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StylerUtils.style((Object)args));
        }
        if (objectName != null) {
            buf.append(this.resolveObjectName(objectName));
            buf.append(' ');
        }
        for (int i = 0; i < args.length - 1; ++i) {
            MessageSourceResolvable arg = args[i];
            buf.append(this.messages.getMessage(arg, this.locale));
            buf.append(' ');
        }
        buf.append(this.messages.getMessage(args[args.length - 1], this.locale));
        buf.append(".");
        return buf.toString();
    }

    private MessageSourceResolvable[] resolveArguments(Constraint constraint) {
        this.args.clear();
        this.visitorSupport.invokeVisit((Object)this, (Object)constraint);
        return this.args.toArray(new MessageSourceResolvable[0]);
    }

    void visit(CompoundPropertyConstraint rule) {
        this.visitorSupport.invokeVisit((Object)this, (Object)rule.getPredicate());
    }

    void visit(PropertiesConstraint e) {
        this.add(this.getMessageCode(e.getConstraint()), new Object[]{this.resolveObjectName(e.getOtherPropertyName())}, e.toString());
    }

    void visit(ParameterizedPropertyConstraint e) {
        this.add(this.getMessageCode(e.getConstraint()), new Object[]{e.getParameter()}, e.toString());
    }

    public void add(String code, Object[] args, String defaultMessage) {
        DefaultMessageSourceResolvable resolvable = new DefaultMessageSourceResolvable(new String[]{code}, args, defaultMessage);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding resolvable: " + resolvable));
        }
        this.args.add(resolvable);
    }

    public String resolveObjectName(String objectName) {
        if (this.objectNameResolver != null) {
            return this.objectNameResolver.resolveObjectName(objectName);
        }
        return this.messages.getMessage(objectName, null, new DefaultBeanPropertyNameRenderer().renderShortName(objectName), this.locale);
    }

    void visit(PropertyValueConstraint valueConstraint) {
        this.visitorSupport.invokeVisit((Object)this, (Object)valueConstraint.getConstraint());
    }

    void visit(CompoundConstraint compoundConstraint) {
        Iterator it = compoundConstraint.iterator();
        String compoundMessage = this.getMessageCode(compoundConstraint);
        while (it.hasNext()) {
            Constraint p = (Constraint)it.next();
            this.visitorSupport.invokeVisit((Object)this, (Object)p);
            if (!it.hasNext()) continue;
            this.add(compoundMessage, null, compoundMessage);
        }
    }

    void visit(Not not) {
        this.add("not", null, "not");
        this.visitorSupport.invokeVisit((Object)this, (Object)not.getConstraint());
    }

    void visit(StringLengthConstraint constraint) {
        ClosureResultConstraint c = (ClosureResultConstraint)constraint.getPredicate();
        Constraint p = c.getPredicate();
        MessageSourceResolvable resolvable = p instanceof ParameterizedBinaryConstraint ? this.handleParameterizedBinaryPredicate((ParameterizedBinaryConstraint)p) : this.handleRange((Range)p);
        Object[] args = new Object[]{resolvable};
        this.add(this.getMessageCode(constraint), args, constraint.toString());
    }

    void visit(ClosureResultConstraint c) {
        this.visitorSupport.invokeVisit((Object)this, (Object)c.getPredicate());
    }

    private MessageSourceResolvable handleParameterizedBinaryPredicate(ParameterizedBinaryConstraint p) {
        DefaultMessageSourceResolvable resolvable = new DefaultMessageSourceResolvable(new String[]{this.getMessageCode(p.getConstraint())}, new Object[]{p.getParameter()}, p.toString());
        return resolvable;
    }

    private MessageSourceResolvable handleRange(Range r) {
        DefaultMessageSourceResolvable resolvable = new DefaultMessageSourceResolvable(new String[]{this.getMessageCode(r)}, new Object[]{r.getMin(), r.getMax()}, r.toString());
        return resolvable;
    }

    void visit(Constraint constraint) {
        if (constraint instanceof Range) {
            this.args.add(this.handleRange((Range)constraint));
        } else if (constraint instanceof ParameterizedBinaryConstraint) {
            this.args.add(this.handleParameterizedBinaryPredicate((ParameterizedBinaryConstraint)constraint));
        } else {
            this.add(this.getMessageCode(constraint), null, constraint.toString());
        }
    }

    protected String getMessageCode(Object o) {
        String type;
        if (o instanceof TypeResolvable && (type = ((TypeResolvable)o).getType()) != null) {
            return type;
        }
        return ClassUtils.getShortNameAsProperty(o.getClass());
    }
}

