/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.reporting;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.closure.Constraint;
import org.springframework.core.style.ToStringCreator;
import org.springframework.rules.constraint.And;
import org.springframework.rules.constraint.CompoundConstraint;
import org.springframework.rules.constraint.Not;
import org.springframework.rules.constraint.Or;

public abstract class ValidationResultsBuilder {
    protected static final Log logger = LogFactory.getLog((Class)ValidationResultsBuilder.class);
    private Constraint top;
    private Stack levels = new Stack();

    public void pushAnd() {
        And and = new And();
        this.add(and);
    }

    public void pushOr() {
        Or or = new Or();
        this.add(or);
    }

    public void pushNot() {
        Not not = new Not();
        this.add(not);
    }

    private void add(Constraint predicate) {
        if (this.top != null) {
            if (this.top instanceof Not) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Negating predicate [" + predicate + "]"));
                }
                ((Not)this.top).setConstraint(predicate);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Aggregating nested predicate [" + predicate + "]"));
                }
                ((CompoundConstraint)this.top).add(predicate);
            }
        }
        this.levels.push(predicate);
        this.top = predicate;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Predicate [" + predicate + "] is at the top."));
        }
    }

    public void push(Constraint constraint) {
        if (this.top instanceof CompoundConstraint) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding constraint [" + constraint + "]"));
            }
            ((CompoundConstraint)this.top).add(constraint);
        } else if (this.top instanceof Not) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Negating constraint [" + constraint + "]"));
            }
            ((Not)this.top).setConstraint(constraint);
        } else if (this.top == null) {
            this.constraintViolated(constraint);
        } else {
            throw new IllegalArgumentException(constraint.toString());
        }
    }

    public void pop(boolean result) {
        Constraint p = (Constraint)this.levels.pop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Top [" + p + "] popped; result was " + result + "; stack now has " + this.levels.size() + " elements"));
        }
        if (this.levels.isEmpty()) {
            if (!result) {
                this.constraintViolated(this.top);
            } else {
                this.constraintSatisfied();
            }
            this.top = null;
        } else {
            this.top = (Constraint)this.levels.peek();
            if (result) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing compound predicate [" + p + "]; tested true."));
                }
                ((CompoundConstraint)this.top).remove(p);
            }
        }
    }

    protected void clear() {
        this.levels.clear();
        this.top = null;
    }

    public boolean negated() {
        if (this.levels.size() == 0) {
            return false;
        }
        return this.peek() instanceof Not;
    }

    private Constraint peek() {
        return (Constraint)this.levels.peek();
    }

    protected abstract void constraintViolated(Constraint var1);

    protected abstract void constraintSatisfied();

    public String toString() {
        return new ToStringCreator((Object)this).append("topOfStack", (Object)this.top).append("levelsStack", (Object)this.levels).toString();
    }
}

