/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import cool.pandora.modeller.ModellerClientFailedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.FcrepoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModellerClient {
    protected static final Logger log = LoggerFactory.getLogger(ModellerClient.class);

    private ModellerClient() {
    }

    public static void doBinaryPut(URI destinationURI, File resourceFile, String contentType) throws ModellerClientFailedException {
        FcrepoClient testClient = FcrepoClient.client().throwExceptionOnFailure().build();
        try {
            FcrepoResponse response = testClient.put(destinationURI).body(resourceFile, contentType).perform();
            log.info(String.valueOf(response.getStatusCode()));
        }
        catch (FcrepoOperationFailedException e) {
            log.info(ExceptionUtils.getMessage((Throwable)e));
            throw new ModellerClientFailedException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void doStreamPut(URI destinationURI, ByteArrayInputStream resourceFile, String contentType) throws ModellerClientFailedException {
        FcrepoClient testClient = FcrepoClient.client().throwExceptionOnFailure().build();
        try {
            FcrepoResponse response = testClient.put(destinationURI).body((InputStream)resourceFile, contentType).perform();
            log.info(String.valueOf(response.getStatusCode()));
        }
        catch (FcrepoOperationFailedException e) {
            log.info(ExceptionUtils.getMessage((Throwable)e));
            throw new ModellerClientFailedException(e);
        }
    }

    public static void doPut(URI destinationURI) throws ModellerClientFailedException {
        FcrepoClient testClient = FcrepoClient.client().throwExceptionOnFailure().build();
        try {
            FcrepoResponse response = testClient.put(destinationURI).perform();
            try {
                log.info(IOUtils.toString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.info(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        catch (FcrepoOperationFailedException e) {
            log.info(ExceptionUtils.getMessage((Throwable)e));
            throw new ModellerClientFailedException(e);
        }
    }

    public static void doPatch(URI destinationURI, InputStream rdfBody) throws ModellerClientFailedException {
        FcrepoClient testClient = FcrepoClient.client().throwExceptionOnFailure().build();
        try {
            FcrepoResponse response = testClient.patch(destinationURI).body(rdfBody).perform();
            log.info(String.valueOf(response.getStatusCode()));
        }
        catch (FcrepoOperationFailedException e) {
            log.info(ExceptionUtils.getMessage((Throwable)e));
            throw new ModellerClientFailedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGetContainerResources(URI containerURI) throws ModellerClientFailedException {
        FcrepoClient testClient = FcrepoClient.client().throwExceptionOnFailure().build();
        try (FcrepoResponse response = testClient.get(containerURI).accept("text/turtle").perform();){
            String string = IOUtils.toString((InputStream)response.getBody(), (String)"UTF-8");
            return string;
        }
        catch (FcrepoOperationFailedException e) {
            log.info(ExceptionUtils.getMessage((Throwable)e));
            throw new ModellerClientFailedException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

