/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.lang.BlankNodeAllocator;
import org.apache.jena.riot.lang.BlankNodeAllocatorHash;
import org.apache.jena.riot.writer.WriterConst;

public class RDFCollectionWriter {
    private final ByteArrayOutputStream rdfCollection;

    public static RDFCollectionBuilder collection() {
        return new RDFCollectionBuilder();
    }

    public String render() {
        return this.rdfCollection.toString();
    }

    RDFCollectionWriter(List<String> idList, String collectionPredicate, String resourceContainerIRI) {
        Model model = ModelFactory.createDefaultModel();
        Map<String, Node> bNodeMap = RDFCollectionWriter.getBNodeKeyMap(idList);
        Resource s = model.createResource(RDFCollectionWriter.getIdentitySubject());
        Property p = model.createProperty(collectionPredicate);
        Node firstBNode = RDFCollectionWriter.getSubjNodeForCurrentIndex(0, bNodeMap);
        Resource o = model.createResource(String.valueOf(firstBNode));
        model.add(s, p, (RDFNode)o);
        for (String id : idList) {
            Resource o2;
            Property p2;
            Resource s2;
            Resource o1;
            Property p1;
            Resource s1;
            String objectURI;
            Node objNode;
            Resource o22;
            Property p22;
            Resource s22;
            Resource o12;
            Property p12;
            Resource s12;
            String objectURI2;
            Node subjNode;
            int pos = RDFCollectionWriter.getIDPos(idList, id);
            String lastId = idList.get(idList.size() - 1);
            if (pos == 0 && Objects.equals(id, lastId)) {
                subjNode = RDFCollectionWriter.getSubjNodeForCurrentIndex(pos, bNodeMap);
                objectURI2 = RDFCollectionWriter.getResourceURI(resourceContainerIRI, id);
                s12 = model.createResource(String.valueOf(subjNode));
                p12 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o12 = model.createResource(objectURI2);
                model.add(s12, p12, (RDFNode)o12);
                s22 = model.createResource(String.valueOf(subjNode));
                p22 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o22 = model.createResource(String.valueOf(WriterConst.RDF_Nil));
                model.add(s22, p22, (RDFNode)o22);
                continue;
            }
            if (pos == 0) {
                subjNode = RDFCollectionWriter.getSubjNodeForCurrentIndex(pos, bNodeMap);
                objNode = RDFCollectionWriter.getObjNodeForCurrentIndex(pos, bNodeMap);
                objectURI = RDFCollectionWriter.getResourceURI(resourceContainerIRI, id);
                s1 = model.createResource(String.valueOf(subjNode));
                p1 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o1 = model.createResource(objectURI);
                model.add(s1, p1, (RDFNode)o1);
                s2 = model.createResource(String.valueOf(subjNode));
                p2 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o2 = model.createResource(String.valueOf(objNode));
                model.add(s2, p2, (RDFNode)o2);
                continue;
            }
            if (Objects.equals(id, lastId)) {
                subjNode = RDFCollectionWriter.getObjNodeFromPrevIndex(pos, bNodeMap);
                objectURI2 = RDFCollectionWriter.getResourceURI(resourceContainerIRI, id);
                s12 = model.createResource(String.valueOf(subjNode));
                p12 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o12 = model.createResource(objectURI2);
                model.add(s12, p12, (RDFNode)o12);
                s22 = model.createResource(String.valueOf(subjNode));
                p22 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o22 = model.createResource(String.valueOf(WriterConst.RDF_Nil));
                model.add(s22, p22, (RDFNode)o22);
                continue;
            }
            subjNode = RDFCollectionWriter.getObjNodeFromPrevIndex(pos, bNodeMap);
            objNode = RDFCollectionWriter.getObjNodeForCurrentIndex(pos, bNodeMap);
            objectURI = RDFCollectionWriter.getResourceURI(resourceContainerIRI, id);
            s1 = model.createResource(String.valueOf(subjNode));
            p1 = model.createProperty(String.valueOf(WriterConst.RDF_First));
            o1 = model.createResource(objectURI);
            model.add(s1, p1, (RDFNode)o1);
            s2 = model.createResource(String.valueOf(subjNode));
            p2 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
            o2 = model.createResource(String.valueOf(objNode));
            model.add(s2, p2, (RDFNode)o2);
        }
        Dataset dataset = DatasetFactory.create((Model)model);
        dataset.addNamedModel("http://iiif.sequence", model);
        this.rdfCollection = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)this.rdfCollection, (Model)model, (Lang)Lang.NTRIPLES);
    }

    private static int getIDPos(List<String> idList, String id) {
        return idList.indexOf(id);
    }

    private static Map<String, Node> getBNodeKeyMap(List<String> idList) {
        HashMap<String, Node> bNodeMap = new HashMap<String, Node>();
        for (String id : idList) {
            int pos = RDFCollectionWriter.getIDPos(idList, id);
            Node sNode = RDFCollectionWriter.getNewBNode();
            Node oNode = RDFCollectionWriter.getNewBNode();
            String subjKey = String.valueOf(pos) + ":subj";
            bNodeMap.put(subjKey, sNode);
            String objKey = String.valueOf(pos) + ":obj";
            bNodeMap.put(objKey, oNode);
        }
        return bNodeMap;
    }

    private static Node getObjNodeFromPrevIndex(int pos, Map<String, Node> bNodeMap) {
        int prevIndex = pos - 1;
        String objKey = String.valueOf(prevIndex) + ":obj";
        return bNodeMap.get(objKey);
    }

    private static Node getSubjNodeForCurrentIndex(int pos, Map<String, Node> bNodeMap) {
        String objKey = String.valueOf(pos) + ":subj";
        return bNodeMap.get(objKey);
    }

    private static Node getObjNodeForCurrentIndex(int pos, Map<String, Node> bNodeMap) {
        String objKey = String.valueOf(pos) + ":obj";
        return bNodeMap.get(objKey);
    }

    private static String getIdentitySubject() {
        return "";
    }

    private static Node getNewBNode() {
        String bNodeLabelStart = "_:";
        RDFCollectionBuilder.Factory fSeededHashAlloc = BlankNodeAllocatorHash::new;
        BlankNodeAllocator alloc = fSeededHashAlloc.create();
        Node n = alloc.create();
        String bnodeLabel = "_:" + String.valueOf(n);
        return NodeFactory.createBlankNode((String)bnodeLabel);
    }

    private static String getResourceURI(String resourceContainerIRI, String resourceID) {
        return resourceContainerIRI + resourceID;
    }

    public static class RDFCollectionBuilder {
        private List<String> idList;
        private String collectionPredicate;
        private String resourceContainerIRI;

        public RDFCollectionBuilder idList(List<String> idList) {
            this.idList = idList;
            return this;
        }

        public RDFCollectionBuilder collectionPredicate(String collectionPredicate) {
            this.collectionPredicate = collectionPredicate;
            return this;
        }

        public RDFCollectionBuilder resourceContainerIRI(String resourceContainerIRI) {
            this.resourceContainerIRI = resourceContainerIRI;
            return this;
        }

        public RDFCollectionWriter build() {
            return new RDFCollectionWriter(this.idList, this.collectionPredicate, this.resourceContainerIRI);
        }

        public static interface Factory {
            public BlankNodeAllocator create();
        }
    }
}

