/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.lang.BlankNodeAllocator;
import org.apache.jena.riot.lang.BlankNodeAllocatorHash;
import org.apache.jena.riot.writer.WriterConst;

public class ResourceCollectionWriter {
    private final ByteArrayOutputStream rdfCollection;

    public static ResourceCollectionBuilder collection() {
        return new ResourceCollectionBuilder();
    }

    public String render() {
        return this.rdfCollection.toString();
    }

    ResourceCollectionWriter(List<String> idList, String collectionPredicate, Map<String, String> resourceTargetMap) {
        Model model = ModelFactory.createDefaultModel();
        Map<String, Node> bNodeMap = ResourceCollectionWriter.getBNodeKeyMap(idList);
        Resource s = model.createResource(ResourceCollectionWriter.getIdentitySubject());
        Property p = model.createProperty(collectionPredicate);
        Node firstBNode = ResourceCollectionWriter.getSubjNodeForCurrentIndex(0, bNodeMap);
        Resource o = model.createResource(String.valueOf(firstBNode));
        model.add(s, p, (RDFNode)o);
        for (String id : idList) {
            Resource o3;
            Property p3;
            Resource o2;
            Property p2;
            Resource o1;
            Property p1;
            Resource o0;
            Property p0;
            Resource s0;
            Node objNode;
            Resource o32;
            Property p32;
            Resource o22;
            Property p22;
            Resource o12;
            Property p12;
            Resource o02;
            Property p02;
            Resource s02;
            Node subjNode;
            int pos = ResourceCollectionWriter.getIDPos(idList, id);
            String lastId = idList.get(idList.size() - 1);
            String canvasURI = resourceTargetMap.get(id);
            if (pos == 0 && Objects.equals(id, lastId)) {
                subjNode = ResourceCollectionWriter.getSubjNodeForCurrentIndex(pos, bNodeMap);
                s02 = model.createResource(String.valueOf(subjNode));
                p02 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o02 = model.createResource();
                model.add(s02, p02, (RDFNode)o02);
                p12 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
                o12 = model.createResource(canvasURI);
                model.add(o02, p12, (RDFNode)o12);
                p22 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o22 = model.createResource(String.valueOf(WriterConst.RDF_Nil));
                model.add(s02, p22, (RDFNode)o22);
                p32 = model.createProperty("http://www.w3.org/ns/oa#hasBody");
                o32 = model.createResource(id);
                model.add(o02, p32, (RDFNode)o32);
                continue;
            }
            if (pos == 0) {
                subjNode = ResourceCollectionWriter.getSubjNodeForCurrentIndex(pos, bNodeMap);
                objNode = ResourceCollectionWriter.getObjNodeForCurrentIndex(pos, bNodeMap);
                s0 = model.createResource(String.valueOf(subjNode));
                p0 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o0 = model.createResource();
                model.add(s0, p0, (RDFNode)o0);
                p1 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
                o1 = model.createResource(canvasURI);
                model.add(o0, p1, (RDFNode)o1);
                p2 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o2 = model.createResource(String.valueOf(objNode));
                model.add(s0, p2, (RDFNode)o2);
                p3 = model.createProperty("http://www.w3.org/ns/oa#hasBody");
                o3 = model.createResource(id);
                model.add(o0, p3, (RDFNode)o3);
                continue;
            }
            if (Objects.equals(id, lastId)) {
                subjNode = ResourceCollectionWriter.getObjNodeFromPrevIndex(pos, bNodeMap);
                s02 = model.createResource(String.valueOf(subjNode));
                p02 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o02 = model.createResource();
                model.add(s02, p02, (RDFNode)o02);
                p12 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
                o12 = model.createResource(canvasURI);
                model.add(o02, p12, (RDFNode)o12);
                p22 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o22 = model.createResource(String.valueOf(WriterConst.RDF_Nil));
                model.add(s02, p22, (RDFNode)o22);
                p32 = model.createProperty("http://www.w3.org/ns/oa#hasBody");
                o32 = model.createResource(id);
                model.add(o02, p32, (RDFNode)o32);
                continue;
            }
            subjNode = ResourceCollectionWriter.getObjNodeFromPrevIndex(pos, bNodeMap);
            objNode = ResourceCollectionWriter.getObjNodeForCurrentIndex(pos, bNodeMap);
            s0 = model.createResource(String.valueOf(subjNode));
            p0 = model.createProperty(String.valueOf(WriterConst.RDF_First));
            o0 = model.createResource();
            model.add(s0, p0, (RDFNode)o0);
            p1 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
            o1 = model.createResource(canvasURI);
            model.add(o0, p1, (RDFNode)o1);
            p2 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
            o2 = model.createResource(String.valueOf(objNode));
            model.add(s0, p2, (RDFNode)o2);
            p3 = model.createProperty("http://www.w3.org/ns/oa#hasBody");
            o3 = model.createResource(id);
            model.add(o0, p3, (RDFNode)o3);
        }
        Dataset dataset = DatasetFactory.create((Model)model);
        dataset.addNamedModel("http://iiif.sequence", model);
        this.rdfCollection = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)this.rdfCollection, (Model)model, (Lang)Lang.NTRIPLES);
    }

    private static int getIDPos(List<String> idList, String id) {
        return idList.indexOf(id);
    }

    private static Map<String, Node> getBNodeKeyMap(List<String> idList) {
        HashMap<String, Node> bNodeMap = new HashMap<String, Node>();
        for (String id : idList) {
            int pos = ResourceCollectionWriter.getIDPos(idList, id);
            Node sNode = ResourceCollectionWriter.getNewBNode();
            Node oNode = ResourceCollectionWriter.getNewBNode();
            String subjKey = String.valueOf(pos) + ":subj";
            bNodeMap.put(subjKey, sNode);
            String objKey = String.valueOf(pos) + ":obj";
            bNodeMap.put(objKey, oNode);
        }
        return bNodeMap;
    }

    private static Node getObjNodeFromPrevIndex(int pos, Map<String, Node> bNodeMap) {
        int prevIndex = pos - 1;
        String objKey = String.valueOf(prevIndex) + ":obj";
        return bNodeMap.get(objKey);
    }

    private static Node getSubjNodeForCurrentIndex(int pos, Map<String, Node> bNodeMap) {
        String objKey = String.valueOf(pos) + ":subj";
        return bNodeMap.get(objKey);
    }

    private static Node getObjNodeForCurrentIndex(int pos, Map<String, Node> bNodeMap) {
        String objKey = String.valueOf(pos) + ":obj";
        return bNodeMap.get(objKey);
    }

    private static String getIdentitySubject() {
        return "";
    }

    private static Node getNewBNode() {
        String bNodeLabelStart = "_:";
        ResourceCollectionBuilder.Factory fSeededHashAlloc = BlankNodeAllocatorHash::new;
        BlankNodeAllocator alloc = fSeededHashAlloc.create();
        Node n = alloc.create();
        String bnodeLabel = "_:" + String.valueOf(n);
        return NodeFactory.createBlankNode((String)bnodeLabel);
    }

    public static class ResourceCollectionBuilder {
        private List<String> idList;
        private String collectionPredicate;
        private Map<String, String> resourceTargetMap;

        public ResourceCollectionBuilder idList(List<String> idList) {
            this.idList = idList;
            return this;
        }

        public ResourceCollectionBuilder collectionPredicate(String collectionPredicate) {
            this.collectionPredicate = collectionPredicate;
            return this;
        }

        public ResourceCollectionBuilder resourceTargetMap(Map<String, String> resourceTargetMap) {
            this.resourceTargetMap = resourceTargetMap;
            return this;
        }

        public ResourceCollectionWriter build() {
            return new ResourceCollectionWriter(this.idList, this.collectionPredicate, this.resourceTargetMap);
        }

        public static interface Factory {
            public BlankNodeAllocator create();
        }
    }
}

