/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.util;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class ResourceList {
    private final URI resourceContainerURI;

    public ResourceList(URI resourceContainerURI) {
        this.resourceContainerURI = resourceContainerURI;
    }

    public ArrayList<String> getResourceList() {
        try {
            String resource = ModellerClient.doGetContainerResources(this.resourceContainerURI);
            Model model = ModelFactory.createDefaultModel();
            model.read((InputStream)new ByteArrayInputStream(resource != null ? resource.getBytes() : new byte[]{}), null, "TTL");
            ArrayList<String> resourceList = ResourceList.getChilden(model);
            resourceList.sort(String.CASE_INSENSITIVE_ORDER);
            return resourceList;
        }
        catch (ModellerClientFailedException e) {
            System.out.println(ExceptionUtils.getMessage((Throwable)e));
            return null;
        }
    }

    private static ArrayList<String> getChilden(Model model) {
        String NS = "http://www.w3.org/ns/ldp#";
        Property ldpcontains = model.getProperty("http://www.w3.org/ns/ldp#contains");
        ArrayList<String> retval = new ArrayList<String>();
        StmtIterator it = model.listStatements((Selector)new SimpleSelector(null, ldpcontains, (RDFNode)((Resource)null)));
        while (it.hasNext()) {
            Statement st = (Statement)it.next();
            retval.add(st.getObject().toString());
        }
        return retval;
    }
}

