/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;

public class ServiceNodeWriter {
    private final ByteArrayOutputStream serviceNode;

    public static ServiceNodeBuilder init() {
        return new ServiceNodeBuilder();
    }

    public String render() {
        return this.serviceNode.toString();
    }

    ServiceNodeWriter(String serviceURI, String servicePredicate, String serviceType) {
        Model model = ModelFactory.createDefaultModel();
        Resource s = model.createResource(ServiceNodeWriter.getIdentitySubject());
        Property p = model.createProperty(servicePredicate);
        Resource o = model.createResource(serviceURI);
        model.add(s, p, (RDFNode)o);
        Dataset dataset = DatasetFactory.create((Model)model);
        dataset.addNamedModel("http://iiif.service", model);
        this.serviceNode = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)this.serviceNode, (Model)model, (Lang)Lang.NTRIPLES);
    }

    private static String getIdentitySubject() {
        return "";
    }

    public static class ServiceNodeBuilder {
        private String servicePredicate;
        private String serviceURI;
        private String serviceType;

        public ServiceNodeBuilder serviceURI(String serviceURI) {
            this.serviceURI = serviceURI;
            return this;
        }

        public ServiceNodeBuilder servicePredicate(String servicePredicate) {
            this.servicePredicate = servicePredicate;
            return this;
        }

        public ServiceNodeBuilder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public ServiceNodeWriter build() {
            return new ServiceNodeWriter(this.serviceURI, this.servicePredicate, this.serviceType);
        }
    }
}

