/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.lang.BlankNodeAllocator;
import org.apache.jena.riot.lang.BlankNodeAllocatorHash;
import org.apache.jena.riot.writer.WriterConst;

public class TextCollectionWriter {
    private final ByteArrayOutputStream rdfCollection;

    public static RDFCollectionBuilder collection() {
        return new RDFCollectionBuilder();
    }

    public String render() {
        return this.rdfCollection.toString();
    }

    TextCollectionWriter(List<String> idList, String collectionPredicate, String resourceContainerIRI, String canvasURI) {
        Model model = ModelFactory.createDefaultModel();
        Map<String, Node> bNodeMap = TextCollectionWriter.getBNodeKeyMap(idList);
        Resource s = model.createResource(TextCollectionWriter.getIdentitySubject());
        Property p = model.createProperty(collectionPredicate);
        Node firstBNode = TextCollectionWriter.getSubjNodeForCurrentIndex(0, bNodeMap);
        Resource o = model.createResource(String.valueOf(firstBNode));
        model.add(s, p, (RDFNode)o);
        for (String id : idList) {
            Resource o2;
            Property p2;
            Resource s2;
            Resource o1;
            Property p1;
            Resource s1;
            Resource o0;
            Property p0;
            Resource s0;
            String objectURI;
            Node objNode;
            Resource o22;
            Property p22;
            Resource s22;
            Resource o12;
            Property p12;
            Resource s12;
            Resource o02;
            Property p02;
            Resource s02;
            String objectURI2;
            Node subjNode;
            int pos = TextCollectionWriter.getIDPos(idList, id);
            String lastId = idList.get(idList.size() - 1);
            if (pos == 0 && Objects.equals(id, lastId)) {
                subjNode = TextCollectionWriter.getSubjNodeForCurrentIndex(pos, bNodeMap);
                objectURI2 = TextCollectionWriter.getResourceURI(resourceContainerIRI, id);
                s02 = model.createResource(String.valueOf(subjNode));
                p02 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o02 = model.createResource(objectURI2);
                model.add(s02, p02, (RDFNode)o02);
                s12 = model.createResource(String.valueOf(subjNode));
                p12 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
                o12 = model.createResource(canvasURI);
                model.add(s12, p12, (RDFNode)o12);
                s22 = model.createResource(String.valueOf(subjNode));
                p22 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o22 = model.createResource(String.valueOf(WriterConst.RDF_Nil));
                model.add(s22, p22, (RDFNode)o22);
                continue;
            }
            if (pos == 0) {
                subjNode = TextCollectionWriter.getSubjNodeForCurrentIndex(pos, bNodeMap);
                objNode = TextCollectionWriter.getObjNodeForCurrentIndex(pos, bNodeMap);
                objectURI = TextCollectionWriter.getResourceURI(resourceContainerIRI, id);
                s0 = model.createResource(String.valueOf(subjNode));
                p0 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o0 = model.createResource(objectURI);
                model.add(s0, p0, (RDFNode)o0);
                s1 = model.createResource(String.valueOf(subjNode));
                p1 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
                o1 = model.createResource(canvasURI);
                model.add(s1, p1, (RDFNode)o1);
                s2 = model.createResource(String.valueOf(subjNode));
                p2 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o2 = model.createResource(String.valueOf(objNode));
                model.add(s2, p2, (RDFNode)o2);
                continue;
            }
            if (Objects.equals(id, lastId)) {
                subjNode = TextCollectionWriter.getObjNodeFromPrevIndex(pos, bNodeMap);
                objectURI2 = TextCollectionWriter.getResourceURI(resourceContainerIRI, id);
                s02 = model.createResource(String.valueOf(subjNode));
                p02 = model.createProperty(String.valueOf(WriterConst.RDF_First));
                o02 = model.createResource(objectURI2);
                model.add(s02, p02, (RDFNode)o02);
                s12 = model.createResource(String.valueOf(subjNode));
                p12 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
                o12 = model.createResource(canvasURI);
                model.add(s12, p12, (RDFNode)o12);
                s22 = model.createResource(String.valueOf(subjNode));
                p22 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
                o22 = model.createResource(String.valueOf(WriterConst.RDF_Nil));
                model.add(s22, p22, (RDFNode)o22);
                continue;
            }
            subjNode = TextCollectionWriter.getObjNodeFromPrevIndex(pos, bNodeMap);
            objNode = TextCollectionWriter.getObjNodeForCurrentIndex(pos, bNodeMap);
            objectURI = TextCollectionWriter.getResourceURI(resourceContainerIRI, id);
            s0 = model.createResource(String.valueOf(subjNode));
            p0 = model.createProperty(String.valueOf(WriterConst.RDF_First));
            o0 = model.createResource(objectURI);
            model.add(s0, p0, (RDFNode)o0);
            s1 = model.createResource(String.valueOf(subjNode));
            p1 = model.createProperty("http://www.w3.org/ns/oa#hasTarget");
            o1 = model.createResource(canvasURI);
            model.add(s1, p1, (RDFNode)o1);
            s2 = model.createResource(String.valueOf(subjNode));
            p2 = model.createProperty(String.valueOf(WriterConst.RDF_Rest));
            o2 = model.createResource(String.valueOf(objNode));
            model.add(s2, p2, (RDFNode)o2);
        }
        Dataset dataset = DatasetFactory.create((Model)model);
        dataset.addNamedModel("http://iiif.sequence", model);
        this.rdfCollection = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)this.rdfCollection, (Model)model, (Lang)Lang.NTRIPLES);
    }

    private static int getIDPos(List<String> idList, String id) {
        return idList.indexOf(id);
    }

    private static Map<String, Node> getBNodeKeyMap(List<String> idList) {
        HashMap<String, Node> bNodeMap = new HashMap<String, Node>();
        for (String id : idList) {
            int pos = TextCollectionWriter.getIDPos(idList, id);
            Node sNode = TextCollectionWriter.getNewBNode();
            Node oNode = TextCollectionWriter.getNewBNode();
            String subjKey = String.valueOf(pos) + ":subj";
            bNodeMap.put(subjKey, sNode);
            String objKey = String.valueOf(pos) + ":obj";
            bNodeMap.put(objKey, oNode);
        }
        return bNodeMap;
    }

    private static Node getObjNodeFromPrevIndex(int pos, Map<String, Node> bNodeMap) {
        int prevIndex = pos - 1;
        String objKey = String.valueOf(prevIndex) + ":obj";
        return bNodeMap.get(objKey);
    }

    private static Node getSubjNodeForCurrentIndex(int pos, Map<String, Node> bNodeMap) {
        String objKey = String.valueOf(pos) + ":subj";
        return bNodeMap.get(objKey);
    }

    private static Node getObjNodeForCurrentIndex(int pos, Map<String, Node> bNodeMap) {
        String objKey = String.valueOf(pos) + ":obj";
        return bNodeMap.get(objKey);
    }

    private static String getIdentitySubject() {
        return "";
    }

    private static Node getNewBNode() {
        String bNodeLabelStart = "_:";
        RDFCollectionBuilder.Factory fSeededHashAlloc = BlankNodeAllocatorHash::new;
        BlankNodeAllocator alloc = fSeededHashAlloc.create();
        Node n = alloc.create();
        String bnodeLabel = "_:" + String.valueOf(n);
        return NodeFactory.createBlankNode((String)bnodeLabel);
    }

    private static String getResourceURI(String resourceContainerIRI, String resourceID) {
        return resourceContainerIRI + resourceID;
    }

    public static class RDFCollectionBuilder {
        private List<String> idList;
        private String collectionPredicate;
        private String resourceContainerIRI;
        private String canvasURI;

        public RDFCollectionBuilder idList(List<String> idList) {
            this.idList = idList;
            return this;
        }

        public RDFCollectionBuilder collectionPredicate(String collectionPredicate) {
            this.collectionPredicate = collectionPredicate;
            return this;
        }

        public RDFCollectionBuilder resourceContainerIRI(String resourceContainerIRI) {
            this.resourceContainerIRI = resourceContainerIRI;
            return this;
        }

        public RDFCollectionBuilder canvasURI(String canvasURI) {
            this.canvasURI = canvasURI;
            return this;
        }

        public TextCollectionWriter build() {
            return new TextCollectionWriter(this.idList, this.collectionPredicate, this.resourceContainerIRI, this.canvasURI);
        }

        public static interface Factory {
            public BlankNodeAllocator create();
        }
    }
}

