/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.script;

import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.richclient.application.support.AbstractView;
import org.springframework.richclient.script.ScriptExecutionException;
import org.springframework.richclient.script.ScriptIOException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptedView
extends AbstractView
implements InitializingBean {
    private Resource script;
    private String engineName;
    private Map<String, Object> scriptBindings;
    private String viewBindingName;
    private String containerBindingName;

    protected JComponent createControl() {
        JPanel container = new JPanel(new BorderLayout());
        ScriptEngine engine = this.createScriptEngine();
        Bindings bindings = engine.createBindings();
        this.populateBindings(bindings, container);
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(bindings, 200);
        context.setBindings(bindings, 100);
        engine.setContext(context);
        try {
            engine.eval(new InputStreamReader(this.script.getInputStream()));
        }
        catch (ScriptException e) {
            throw new ScriptExecutionException("error running script", e);
        }
        catch (IOException e) {
            throw new ScriptIOException("error reading script", e);
        }
        return container;
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager(((Object)((Object)this)).getClass().getClassLoader());
        if (StringUtils.hasText((String)this.engineName)) {
            return manager.getEngineByName(this.engineName);
        }
        return manager.getEngineByExtension(this.getExtension(this.script.getFilename()));
    }

    private String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1);
    }

    protected void populateBindings(Bindings bindings, JComponent container) {
        if (StringUtils.hasText((String)this.containerBindingName)) {
            bindings.put(this.containerBindingName, (Object)container);
        }
        if (StringUtils.hasText((String)this.viewBindingName)) {
            bindings.put(this.viewBindingName, (Object)this);
        }
        if (this.scriptBindings != null) {
            for (String key : this.scriptBindings.keySet()) {
                bindings.put(key, this.scriptBindings.get(key));
            }
        }
    }

    public void setScript(Resource script) {
        this.script = script;
    }

    public void setEngineName(String name) {
        this.engineName = name;
    }

    public void setScriptBindings(Map<String, Object> bindings) {
        this.scriptBindings = new HashMap<String, Object>(bindings);
    }

    public void setViewBindingName(String viewBindingName) {
        this.viewBindingName = viewBindingName;
    }

    public void setContainerBindingName(String containerBindingName) {
        this.containerBindingName = containerBindingName;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.script, (String)"script must be set");
    }
}

