/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessor;
import org.springframework.binding.MutablePropertyAccessStrategy;
import org.springframework.binding.PropertyMetadataAccessStrategy;
import org.springframework.binding.support.PropertyChangeSupportUtils;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModel;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;

public abstract class AbstractPropertyAccessStrategy
implements MutablePropertyAccessStrategy {
    private final ValueModel domainObjectHolder;
    private final String basePropertyPath;
    private final ValueModelCache valueModelCache;
    private final PropertyMetadataAccessStrategy metaAspectAccessor;

    public AbstractPropertyAccessStrategy(Object object) {
        this(new ValueHolder(object));
    }

    public AbstractPropertyAccessStrategy(ValueModel domainObjectHolder) {
        Assert.notNull((Object)domainObjectHolder, (String)"domainObjectHolder must not be null.");
        this.domainObjectHolder = domainObjectHolder;
        this.domainObjectHolder.addValueChangeListener(new DomainObjectChangeListener());
        this.basePropertyPath = "";
        this.valueModelCache = new ValueModelCache();
        this.metaAspectAccessor = new PropertyMetaAspectAccessor();
    }

    protected AbstractPropertyAccessStrategy(AbstractPropertyAccessStrategy parent, String basePropertyPath) {
        this.domainObjectHolder = parent.getPropertyValueModel(basePropertyPath);
        this.basePropertyPath = basePropertyPath;
        this.valueModelCache = parent.valueModelCache;
        this.metaAspectAccessor = new PropertyMetaAspectAccessor();
    }

    protected Object getUserMetadataFor(String propertyPath, String key) {
        Map allMetadata = this.getAllUserMetadataFor(propertyPath);
        return allMetadata != null ? allMetadata.get(key) : null;
    }

    protected Map getAllUserMetadataFor(String propertyPath) {
        return null;
    }

    protected abstract PropertyAccessor getPropertyAccessor();

    public ValueModel getDomainObjectHolder() {
        return this.domainObjectHolder;
    }

    public ValueModel getPropertyValueModel(String propertyPath) throws BeansException {
        return (ValueModel)this.valueModelCache.get(this.getFullPropertyPath(propertyPath));
    }

    protected String getFullPropertyPath(String propertyPath) {
        if (this.basePropertyPath.equals("")) {
            return propertyPath;
        }
        if (propertyPath.equals("")) {
            return this.basePropertyPath;
        }
        return this.basePropertyPath + '.' + propertyPath;
    }

    protected String getPropertyName(String propertyPath) {
        int lastSeparator = this.getLastPropertySeparatorIndex(propertyPath);
        if (lastSeparator == -1) {
            return propertyPath;
        }
        if (propertyPath.charAt(lastSeparator) == '.') {
            return propertyPath.substring(lastSeparator + 1);
        }
        return propertyPath.substring(lastSeparator);
    }

    protected String getParentPropertyPath(String propertyPath) {
        int lastSeparator = this.getLastPropertySeparatorIndex(propertyPath);
        return lastSeparator == -1 ? "" : propertyPath.substring(0, lastSeparator);
    }

    protected int getLastPropertySeparatorIndex(String propertyPath) {
        boolean inKey = false;
        block5: for (int i = propertyPath.length() - 1; i >= 0; --i) {
            switch (propertyPath.charAt(i)) {
                case ']': {
                    inKey = true;
                    continue block5;
                }
                case '[': {
                    return i;
                }
                case '.': {
                    if (inKey) continue block5;
                    return i;
                }
            }
        }
        return -1;
    }

    public abstract MutablePropertyAccessStrategy getPropertyAccessStrategyForPath(String var1) throws BeansException;

    public abstract MutablePropertyAccessStrategy newPropertyAccessStrategy(ValueModel var1);

    public Object getDomainObject() {
        return this.domainObjectHolder.getValue();
    }

    public PropertyMetadataAccessStrategy getMetadataAccessStrategy() {
        return this.metaAspectAccessor;
    }

    public Object getPropertyValue(String propertyPath) throws BeansException {
        return this.getPropertyValueModel(propertyPath).getValue();
    }

    protected abstract void domainObjectChanged();

    private class PropertyMetaAspectAccessor
    implements PropertyMetadataAccessStrategy {
        private PropertyMetaAspectAccessor() {
        }

        public Class getPropertyType(String propertyPath) {
            return AbstractPropertyAccessStrategy.this.getPropertyAccessor().getPropertyType(AbstractPropertyAccessStrategy.this.getFullPropertyPath(propertyPath));
        }

        public boolean isReadable(String propertyPath) {
            return AbstractPropertyAccessStrategy.this.getPropertyAccessor().isReadableProperty(AbstractPropertyAccessStrategy.this.getFullPropertyPath(propertyPath));
        }

        public boolean isWriteable(String propertyPath) {
            return AbstractPropertyAccessStrategy.this.getPropertyAccessor().isWritableProperty(AbstractPropertyAccessStrategy.this.getFullPropertyPath(propertyPath));
        }

        public Object getUserMetadata(String propertyPath, String key) {
            return AbstractPropertyAccessStrategy.this.getUserMetadataFor(propertyPath, key);
        }

        public Map getAllUserMetadata(String propertyPath) {
            return AbstractPropertyAccessStrategy.this.getAllUserMetadataFor(propertyPath);
        }
    }

    private class PropertyValueModel
    extends AbstractValueModel {
        private final ValueModel parentValueModel;
        private final String propertyPath;
        private final String propertyName;
        private PropertyChangeListener beanPropertyChangeListener;
        private Object savedParentObject;
        private Object savedPropertyValue;
        private boolean settingBeanProperty;

        public PropertyValueModel(ValueModel parentValueModel, String propertyPath) {
            this.parentValueModel = parentValueModel;
            this.parentValueModel.addValueChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    PropertyValueModel.this.parentValueChanged();
                }
            });
            this.propertyPath = propertyPath;
            this.propertyName = AbstractPropertyAccessStrategy.this.getPropertyName(propertyPath);
            if (AbstractPropertyAccessStrategy.this.getPropertyAccessor().isReadableProperty(propertyPath)) {
                this.savedPropertyValue = AbstractPropertyAccessStrategy.this.getPropertyAccessor().getPropertyValue(propertyPath);
            }
            this.updateBeanPropertyChangeListener();
        }

        public Object getValue() {
            this.savedPropertyValue = AbstractPropertyAccessStrategy.this.getPropertyAccessor().getPropertyValue(this.propertyPath);
            return this.savedPropertyValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            try {
                this.settingBeanProperty = true;
                AbstractPropertyAccessStrategy.this.getPropertyAccessor().setPropertyValue(this.propertyPath, value);
            }
            finally {
                this.settingBeanProperty = false;
            }
            this.fireValueChange(this.savedPropertyValue, value);
            this.savedPropertyValue = value;
        }

        private void parentValueChanged() {
            this.updateBeanPropertyChangeListener();
            this.fireValueChange(this.savedPropertyValue, this.getValue());
        }

        private void propertyValueChanged() {
            if (!this.settingBeanProperty) {
                this.fireValueChange(this.savedPropertyValue, this.getValue());
            }
        }

        private synchronized void updateBeanPropertyChangeListener() {
            Object currentParentObject = this.parentValueModel.getValue();
            if (currentParentObject != this.savedParentObject) {
                if (this.beanPropertyChangeListener != null) {
                    PropertyChangeSupportUtils.removePropertyChangeListener(this.savedParentObject, this.propertyName, this.beanPropertyChangeListener);
                    this.beanPropertyChangeListener = null;
                }
                if (currentParentObject != null && PropertyChangeSupportUtils.supportsBoundProperties(currentParentObject.getClass())) {
                    this.beanPropertyChangeListener = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            PropertyValueModel.this.propertyValueChanged();
                        }
                    };
                    PropertyChangeSupportUtils.addPropertyChangeListener(currentParentObject, this.propertyName, this.beanPropertyChangeListener);
                }
                this.savedParentObject = currentParentObject;
            }
        }
    }

    private class ValueModelCache
    extends CachingMapDecorator {
        private ValueModelCache() {
        }

        protected Object create(Object propertyPath) {
            String fullPropertyPath = AbstractPropertyAccessStrategy.this.getFullPropertyPath((String)propertyPath);
            String parentPropertyPath = AbstractPropertyAccessStrategy.this.getParentPropertyPath(fullPropertyPath);
            ValueModel parentValueModel = parentPropertyPath == "" ? AbstractPropertyAccessStrategy.this.domainObjectHolder : (ValueModel)AbstractPropertyAccessStrategy.this.valueModelCache.get(parentPropertyPath);
            return new PropertyValueModel(parentValueModel, fullPropertyPath);
        }
    }

    private class DomainObjectChangeListener
    implements PropertyChangeListener {
        private DomainObjectChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractPropertyAccessStrategy.this.domainObjectChanged();
        }
    }
}

