/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.support;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessor;
import org.springframework.binding.MutablePropertyAccessStrategy;
import org.springframework.binding.support.AbstractPropertyAccessStrategy;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.ValueHolder;

public class BeanPropertyAccessStrategy
extends AbstractPropertyAccessStrategy {
    private final BeanWrapper beanWrapper;

    public BeanPropertyAccessStrategy(Object bean) {
        this(new ValueHolder(bean));
    }

    public BeanPropertyAccessStrategy(ValueModel domainObjectHolder) {
        super(domainObjectHolder);
        this.beanWrapper = new BeanWrapperImpl(false);
        this.beanWrapper.setWrappedInstance(domainObjectHolder.getValue());
    }

    protected BeanPropertyAccessStrategy(BeanPropertyAccessStrategy parent, String basePropertyPath) {
        super(parent, basePropertyPath);
        this.beanWrapper = parent.beanWrapper;
    }

    protected BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    protected PropertyAccessor getPropertyAccessor() {
        return this.beanWrapper;
    }

    public MutablePropertyAccessStrategy getPropertyAccessStrategyForPath(String propertyPath) throws BeansException {
        return new BeanPropertyAccessStrategy(this, this.getFullPropertyPath(propertyPath));
    }

    public MutablePropertyAccessStrategy newPropertyAccessStrategy(ValueModel domainObjectHolder) {
        return new BeanPropertyAccessStrategy(domainObjectHolder);
    }

    protected void domainObjectChanged() {
        this.beanWrapper.setWrappedInstance(this.getDomainObject());
    }
}

