/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.springframework.binding.value.DerivedValueModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModel;

public abstract class AbstractDerivedValueModel
extends AbstractValueModel
implements DerivedValueModel {
    private final ValueModel[] sourceValueModels;
    private final PropertyChangeListener sourceChangeHandler;

    protected AbstractDerivedValueModel(ValueModel[] sourceValueModels) {
        this.sourceValueModels = sourceValueModels;
        this.sourceChangeHandler = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractDerivedValueModel.this.sourceValuesChanged();
            }
        };
        for (int i = 0; i < sourceValueModels.length; ++i) {
            sourceValueModels[i].addValueChangeListener(this.sourceChangeHandler);
        }
    }

    public ValueModel[] getSourceValueModels() {
        return this.sourceValueModels;
    }

    protected Object[] getSourceValues() {
        Object[] values = new Object[this.sourceValueModels.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.sourceValueModels[i].getValue();
        }
        return values;
    }

    protected abstract void sourceValuesChanged();

    public boolean isReadOnly() {
        return true;
    }

    public void setValue(Object newValue) {
        throw new UnsupportedOperationException("This value model is read only");
    }
}

