/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.value.ValueChangeDetector;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractPropertyChangePublisher;
import org.springframework.richclient.application.ApplicationServicesLocator;

public abstract class AbstractValueModel
extends AbstractPropertyChangePublisher
implements ValueModel {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ThreadLocal listenerToSkipHolder = new ThreadLocal();
    private ValueChangeDetector valueChangeDetector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValueSilently(Object newValue, PropertyChangeListener listenerToSkip) {
        Object oldListenerToSkip = this.listenerToSkipHolder.get();
        try {
            this.listenerToSkipHolder.set(listenerToSkip);
            this.setValue(newValue);
        }
        finally {
            this.listenerToSkipHolder.set(oldListenerToSkip);
        }
    }

    public final void addValueChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener("value", listener);
    }

    public final void removeValueChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener("value", listener);
    }

    protected void fireValueChangeWhenStillEqual() {
        Object value = this.getValue();
        this.fireValueChangeEvent(value, value);
    }

    protected final void fireValueChange(boolean oldValue, boolean newValue) {
        this.fireValueChange((Object)oldValue, (Object)newValue);
    }

    protected final void fireValueChange(int oldValue, int newValue) {
        this.fireValueChange(new Integer(oldValue), new Integer(newValue));
    }

    protected final void fireValueChange(long oldValue, long newValue) {
        this.fireValueChange(new Long(oldValue), new Long(newValue));
    }

    protected final void fireValueChange(double oldValue, double newValue) {
        this.fireValueChange(new Double(oldValue), new Double(newValue));
    }

    protected void fireValueChange(Object oldValue, Object newValue) {
        if (this.hasValueChanged(oldValue, newValue)) {
            this.fireValueChangeEvent(oldValue, newValue);
        }
    }

    protected boolean hasValueChanged(Object oldValue, Object newValue) {
        return this.getValueChangeDetector().hasValueChanged(oldValue, newValue);
    }

    protected void fireValueChangeEvent(Object oldValue, Object newValue) {
        PropertyChangeListener[] propertyChangeListeners;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Firing value changed event. Old value='" + oldValue + "' new value='" + newValue + "'"));
        }
        if ((propertyChangeListeners = this.getPropertyChangeListeners("value")).length > 0) {
            Object listenerToSkip = this.listenerToSkipHolder.get();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "value", oldValue, newValue);
            for (int i = 0; i < propertyChangeListeners.length; ++i) {
                PropertyChangeListener listener = propertyChangeListeners[i];
                if (listener == listenerToSkip) continue;
                listener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public void setValueChangeDetector(ValueChangeDetector valueChangeDetector) {
        this.valueChangeDetector = valueChangeDetector;
    }

    protected ValueChangeDetector getValueChangeDetector() {
        if (this.valueChangeDetector == null) {
            this.valueChangeDetector = (ValueChangeDetector)ApplicationServicesLocator.services().getService(ValueChangeDetector.class);
        }
        return this.valueChangeDetector;
    }
}

