/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.lang.reflect.Method;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractDerivedValueModel;
import org.springframework.util.Assert;

public final class MethodInvokingDerivedValueModel
extends AbstractDerivedValueModel {
    private final Object target;
    private final Method method;
    private Object value;

    public MethodInvokingDerivedValueModel(Object target, String methodName, ValueModel[] paramSourceValueModels) {
        super(paramSourceValueModels);
        this.target = target;
        this.method = this.getPropertyMethod(target, methodName, paramSourceValueModels.length);
        Assert.notNull((Object)this.method, (String)("No method with name [" + methodName + "] and " + paramSourceValueModels.length + " parameters found on class."));
        this.sourceValuesChanged();
    }

    protected void sourceValuesChanged() {
        Object oldValue = this.value;
        try {
            this.value = this.method.invoke(this.target, this.getSourceValues());
            this.fireValueChange(oldValue, this.value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getValue() {
        return this.value;
    }

    private Method getPropertyMethod(Object target, String methodName, int numberOfParams) {
        Method propertyMethod = null;
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != numberOfParams) continue;
            if (propertyMethod != null) {
                throw new UnsupportedOperationException("Found than one method with name '" + methodName + "' and " + numberOfParams + " parameters on class '" + target.getClass().getName() + "'.");
            }
            propertyMethod = method;
        }
        return propertyMethod;
    }
}

