/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import org.springframework.binding.value.support.ValueHolder;
import org.springframework.core.closure.Closure;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;

public class RefreshableValueHolder
extends ValueHolder {
    private final Closure refreshFunction;
    private boolean alwaysRefresh;

    public RefreshableValueHolder(Closure refreshFunction) {
        this(refreshFunction, false);
    }

    public RefreshableValueHolder(Closure refreshFunction, boolean alwaysRefresh) {
        this(refreshFunction, alwaysRefresh, true);
    }

    public RefreshableValueHolder(Closure refreshFunction, boolean alwaysRefresh, boolean lazyInit) {
        Assert.notNull((Object)refreshFunction, (String)"The refresh callback cannot be null");
        this.refreshFunction = refreshFunction;
        this.alwaysRefresh = alwaysRefresh;
        if (!lazyInit) {
            this.refresh();
        }
    }

    public Object getValue() {
        if (this.alwaysRefresh) {
            this.refresh();
        }
        return super.getValue();
    }

    public void refresh() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing held value '" + StylerUtils.style((Object)super.getValue()) + "'"));
        }
        this.setValue(this.refreshFunction.call(null));
    }
}

