/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.beans.PropertyChangeListener;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.value.DerivedValueModel;
import org.springframework.binding.value.ValueChangeDetector;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModelWrapper;
import org.springframework.core.closure.Closure;
import org.springframework.richclient.application.ApplicationServicesLocator;

public class TypeConverter
extends AbstractValueModelWrapper
implements DerivedValueModel {
    private final Closure convertTo;
    private final Closure convertFrom;
    private ValueChangeDetector valueChangeDetector;

    public TypeConverter(ValueModel wrappedModel, ConversionExecutor convertTo, ConversionExecutor convertFrom) {
        this(wrappedModel, new ConversionExecutorClosure(convertTo), new ConversionExecutorClosure(convertFrom));
    }

    public TypeConverter(ValueModel wrappedModel, Closure convertTo, Closure convertFrom) {
        super(wrappedModel);
        this.convertTo = convertFrom;
        this.convertFrom = convertTo;
    }

    public Object getValue() throws IllegalArgumentException {
        return this.convertFrom.call(super.getValue());
    }

    public void setValueSilently(Object value, PropertyChangeListener listenerToSkip) throws IllegalArgumentException {
        if (this.getValueChangeDetector().hasValueChanged(this.getValue(), value)) {
            super.setValueSilently(this.convertTo.call(value), listenerToSkip);
        }
    }

    public ValueModel[] getSourceValueModels() {
        return new ValueModel[]{this.getWrappedValueModel()};
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setValueChangeDetector(ValueChangeDetector valueChangeDetector) {
        this.valueChangeDetector = valueChangeDetector;
    }

    protected ValueChangeDetector getValueChangeDetector() {
        if (this.valueChangeDetector == null) {
            this.valueChangeDetector = (ValueChangeDetector)ApplicationServicesLocator.services().getService(ValueChangeDetector.class);
        }
        return this.valueChangeDetector;
    }

    private static class ConversionExecutorClosure
    implements Closure {
        private final ConversionExecutor conversionExecutor;

        public ConversionExecutorClosure(ConversionExecutor conversionExecutor) {
            this.conversionExecutor = conversionExecutor;
        }

        public Object call(Object argument) {
            return this.conversionExecutor.execute(argument);
        }
    }
}

