/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.bag;

import cool.pandora.modeller.ProfileField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BagInfoField
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TEXTFIELD_COMPONENT = 1;
    public static final int TEXTAREA_COMPONENT = 2;
    public static final int LIST_COMPONENT = 3;
    public static final String TEXTFIELD_CODE = "TF";
    public static final String TEXTAREA_CODE = "TA";
    public static final int MAX_VALUE = 32;
    private String name = "";
    private String label = "";
    private String value = "";
    private List<String> elements = new ArrayList<String>();
    private int componentType = 1;
    private boolean isEnabled = true;
    private boolean isRequired = false;
    private boolean isRequiredvalue = false;
    private boolean isEditable = true;
    private boolean isProfile = false;

    public BagInfoField() {
    }

    public BagInfoField(ProfileField projectProfile) {
        this.setLabel(projectProfile.getFieldName());
        this.setName(this.getLabel());
        this.setComponentType(1);
        this.isEnabled(!projectProfile.isReadOnly());
        this.isEditable(!projectProfile.isReadOnly());
        this.isRequiredvalue(projectProfile.getIsValueRequired());
        this.isRequired(projectProfile.getIsRequired());
        this.setValue(projectProfile.getFieldValue());
        if (projectProfile.isReadOnly()) {
            this.isEnabled(false);
        }
        this.buildElements(projectProfile.getElements());
        if (projectProfile.getFieldType().equalsIgnoreCase(TEXTFIELD_CODE)) {
            this.setComponentType(1);
        } else if (projectProfile.getFieldType().equalsIgnoreCase(TEXTAREA_CODE)) {
            this.setComponentType(2);
        } else if (!projectProfile.getElements().isEmpty()) {
            this.setComponentType(3);
        }
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getLabel() {
        return this.label;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public String getValue() {
        return this.value;
    }

    public void setElements(List<String> e) {
        this.elements = e;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setComponentType(int type) {
        this.componentType = type;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public void isEditable(boolean b) {
        this.isEditable = b;
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void isEnabled(boolean b) {
        this.isEnabled = b;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void isRequired(boolean b) {
        this.isRequired = b;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void isRequiredvalue(boolean b) {
        this.isRequiredvalue = b;
    }

    private boolean isRequiredvalue() {
        return this.isRequiredvalue;
    }

    public void isProfile(boolean b) {
        this.isProfile = b;
    }

    public boolean isProfile() {
        return this.isProfile;
    }

    public void buildElements(List<String> elementList) {
        this.elements = elementList;
    }

    public String toString() {
        return "\nLabel: " + this.getLabel() + "\nName: " + this.getName() + "\nValue: " + this.getValue() + "\nType: " + this.getComponentType() + "\nElements: " + this.getElements() + "\nisRequired: " + this.isRequired() + "\nisRequiredvalue: " + this.isRequiredvalue() + "\nisEnabled: " + this.isEnabled() + "\nisEditable: " + this.isEditable() + "\n";
    }
}

