/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.bag;

import gov.loc.repository.bagit.utilities.FilenameHelper;
import java.io.File;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaggerFileEntity {
    protected static final Logger log = LoggerFactory.getLogger(BaggerFileEntity.class);
    private File rootParent;
    private File rootSrc;
    private File bagSrc;
    private String normalizedName;
    private boolean isInBag = false;
    private boolean isIncluded = true;

    public String toString() {
        return this.getNormalizedName();
    }

    public void setNormalizedName(String name) {
        this.normalizedName = name;
    }

    private String getNormalizedName() {
        return this.normalizedName;
    }

    public void setRootParent(File file) {
        this.rootParent = file;
    }

    public File getRootParent() {
        return this.rootParent;
    }

    public void setRootSrc(File file) {
        this.rootSrc = file;
    }

    public File getRootSrc() {
        return this.rootSrc;
    }

    public void setBagSrc(File bagDir, File src) {
        this.bagSrc = new File(bagDir, src.getPath());
    }

    public void setBagSrc(File file) {
        this.bagSrc = file;
    }

    public File getBagSrc() {
        return this.bagSrc;
    }

    public void setIsInBag(boolean b) {
        this.isInBag = b;
    }

    public boolean getIsInBag() {
        return this.isInBag;
    }

    public void setIsIncluded(boolean b) {
        this.isIncluded = b;
    }

    public boolean getIsIncluded() {
        return this.isIncluded;
    }

    public boolean copyRootToBag() {
        boolean success = false;
        this.isInBag = true;
        return false;
    }

    public static String removeBasePath(String basePath, String filename) throws RuntimeException {
        String filenameWithoutBasePath;
        if (filename == null) {
            throw new RuntimeException("Cannot remove basePath from null");
        }
        String normBasePath = BaggerFileEntity.normalize(basePath);
        String normFilename = BaggerFileEntity.normalize(filename);
        if (basePath == null) {
            filenameWithoutBasePath = normFilename;
        } else {
            if (!normFilename.startsWith(normBasePath)) {
                throw new RuntimeException(MessageFormat.format("Cannot remove basePath {0} from {1}", basePath, filename));
            }
            if (normBasePath.equals(normFilename)) {
                filenameWithoutBasePath = "";
            } else {
                int delta = normBasePath.endsWith("/") || normBasePath.endsWith("\\") ? 0 : 1;
                filenameWithoutBasePath = normFilename.substring(normBasePath.length() + delta);
                log.trace("filenamewithoutbasepath: {}", (Object)filenameWithoutBasePath);
            }
        }
        log.debug(MessageFormat.format("Removing {0} from {1} resulted in {2}", basePath, filename, filenameWithoutBasePath));
        return filenameWithoutBasePath;
    }

    public static String removeFileExtension(String filename) throws RuntimeException {
        if (filename == null) {
            throw new RuntimeException("Cannot remove file extension from null");
        }
        return filename.split("\\.[^\\.]*$")[0];
    }

    public static String normalize(String filename) {
        return FilenameHelper.normalizePathSeparators((String)filename);
    }
}

