/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.bag.impl;

import cool.pandora.modeller.Contact;
import cool.pandora.modeller.Organization;
import cool.pandora.modeller.Profile;
import cool.pandora.modeller.ProfileField;
import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.BaggerSourceOrganization;
import cool.pandora.modeller.profile.BaggerProfileStore;
import gov.loc.repository.bagit.BagInfoTxt;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBagInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(DefaultBagInfo.class);
    public static final String FIELD_LC_PROJECT = "Profile Name";
    private static final String[] ORGANIZATION_CONTACT_FIELDS = new String[]{"Source-Organization", "Organization-Address", "Contact-Name", "Contact-Phone", "Contact-Email", "To-Contact-Name", "To-Contact-Phone", "To-Contact-Email"};
    private static final String[] MANIFEST_PROPERTY_FIELDS = new String[]{"Attribution", "Author", "Label", "License", "Logo URI", "Description", "Published", "Rendering URI", "Rendering MIME Type", "Rendering Label"};
    private static final HashSet<String> ORGANIZATION_CONTACT_FIELD_SET = new HashSet<String>(Arrays.asList(ORGANIZATION_CONTACT_FIELDS));
    private static final HashSet<String> MANIFEST_PROPERTY_FIELD_SET = new HashSet<String>(Arrays.asList(MANIFEST_PROPERTY_FIELDS));
    private BaggerSourceOrganization sourceOrganization = new BaggerSourceOrganization();
    private Contact toContact = new Contact(true);
    private LinkedHashMap<String, BagInfoField> fieldMap = new LinkedHashMap();

    public BaggerSourceOrganization getBagOrganization() {
        return this.sourceOrganization;
    }

    public HashMap<String, BagInfoField> getFieldMap() {
        return this.fieldMap;
    }

    void addField(BagInfoField field) {
        this.fieldMap.put(field.getName(), field);
    }

    public void update(BagInfoTxt bagInfoTxt) {
        this.updateBagInfoFieldMapFromBilBag(bagInfoTxt);
        this.sourceOrganization = new BaggerSourceOrganization(bagInfoTxt);
        this.toContact = new Contact(true);
        this.toContact.setContactName(ProfileField.createProfileField((String)"To-Contact-Name", (String)((String)bagInfoTxt.getOrDefault((Object)"To-Contact-Name", (Object)""))));
        this.toContact.setTelephone(ProfileField.createProfileField((String)"To-Contact-Phone", (String)((String)bagInfoTxt.getOrDefault((Object)"To-Contact-Phone", (Object)""))));
        this.toContact.setEmail(ProfileField.createProfileField((String)"To-Contact-Email", (String)((String)bagInfoTxt.getOrDefault((Object)"To-Contact-Email", (Object)""))));
        for (String key : bagInfoTxt.keySet()) {
            BagInfoField infoField = new BagInfoField();
            infoField.setLabel(key);
            infoField.setName(key);
            infoField.setValue((String)bagInfoTxt.get((Object)key));
            infoField.isEditable(true);
            infoField.isEnabled(true);
            this.fieldMap.put(key, infoField);
        }
    }

    private void updateBagInfoFieldMapFromBilBag(BagInfoTxt bagInfoTxt) {
        if (this.fieldMap != null) {
            for (Map.Entry<String, BagInfoField> entry : this.fieldMap.entrySet()) {
                String value = (String)bagInfoTxt.get((Object)entry.getKey());
                entry.getValue().setValue(value);
            }
        }
    }

    void setProfile(Profile profile, boolean newBag) {
        if (newBag) {
            Contact contact;
            Contact person = profile.getSendToContact();
            if (person == null) {
                person = new Contact(true);
            }
            if ((contact = profile.getSendFromContact()) == null) {
                contact = new Contact(false);
            }
            this.sourceOrganization.setContact(contact);
            Organization org = profile.getOrganization();
            if (org == null) {
                org = new Organization();
            }
            this.sourceOrganization.setOrganizationName(org.getName().getFieldValue());
            this.sourceOrganization.setOrganizationAddress(org.getAddress().getFieldValue());
            this.toContact = person;
        }
        this.applyProfileToFieldMap(profile);
    }

    private void applyProfileToFieldMap(Profile profile) {
        if (profile != null) {
            if (profile.isNoProfile()) {
                if (this.fieldMap.containsKey(FIELD_LC_PROJECT)) {
                    this.fieldMap.remove(FIELD_LC_PROJECT);
                }
            } else {
                BagInfoField field = new BagInfoField();
                field.setLabel(FIELD_LC_PROJECT);
                field.setName(FIELD_LC_PROJECT);
                field.setComponentType(1);
                field.isEnabled(false);
                field.isEditable(false);
                field.isRequiredvalue(true);
                field.isRequired(true);
                field.setValue(profile.getName());
                field.setComponentType(1);
                this.fieldMap.put(field.getLabel(), field);
            }
            List<ProfileField> list = BaggerProfileStore.getInstance().getProfileFields(profile.getName());
            LinkedHashMap<String, ProfileField> profileFields = DefaultBagInfo.convertToMap(list);
            if (this.fieldMap.size() > 0) {
                for (BagInfoField field : this.fieldMap.values()) {
                    ProfileField projectProfile = profileFields.get(field.getLabel());
                    if (projectProfile == null) continue;
                    field.isEnabled(!projectProfile.isReadOnly());
                    field.isEditable(!projectProfile.isReadOnly());
                    field.isRequiredvalue(projectProfile.getIsValueRequired());
                    field.isRequired(projectProfile.getIsRequired());
                    field.buildElements(projectProfile.getElements());
                    if (projectProfile.getFieldType().equalsIgnoreCase("TF")) {
                        field.setComponentType(1);
                        continue;
                    }
                    if (projectProfile.getFieldType().equalsIgnoreCase("TA")) {
                        field.setComponentType(2);
                        continue;
                    }
                    if (projectProfile.getElements().isEmpty()) continue;
                    field.setComponentType(3);
                }
            }
            LinkedHashMap<String, ProfileField> exclusiveProfileFields = new LinkedHashMap<String, ProfileField>();
            exclusiveProfileFields.putAll(profileFields);
            exclusiveProfileFields.keySet().removeAll(this.fieldMap.keySet());
            if (exclusiveProfileFields.size() > 0) {
                for (ProfileField profileField : exclusiveProfileFields.values()) {
                    if (profileField == null) continue;
                    BagInfoField field = new BagInfoField();
                    field.setLabel(profileField.getFieldName());
                    field.setName(field.getLabel());
                    field.setComponentType(1);
                    field.isEnabled(!profileField.isReadOnly());
                    field.isEditable(!profileField.isReadOnly());
                    field.isRequiredvalue(profileField.getIsValueRequired());
                    field.isRequired(profileField.getIsRequired());
                    field.setValue(profileField.getFieldValue());
                    if (profileField.isReadOnly()) {
                        field.isEnabled(false);
                    }
                    field.buildElements(profileField.getElements());
                    if (profileField.getFieldType().equalsIgnoreCase("TF")) {
                        field.setComponentType(1);
                    } else if (profileField.getFieldType().equalsIgnoreCase("TA")) {
                        field.setComponentType(2);
                    } else if (!profileField.getElements().isEmpty()) {
                        field.setComponentType(3);
                    }
                    this.fieldMap.put(field.getLabel(), field);
                }
            }
        }
    }

    private static LinkedHashMap<String, ProfileField> convertToMap(List<ProfileField> profileFields) {
        LinkedHashMap<String, ProfileField> filedsToReturn = new LinkedHashMap<String, ProfileField>();
        if (profileFields == null) {
            return filedsToReturn;
        }
        for (ProfileField profileFiled : profileFields) {
            filedsToReturn.put(profileFiled.getFieldName(), profileFiled);
        }
        return filedsToReturn;
    }

    void clearFields() {
        this.fieldMap = new LinkedHashMap();
    }

    void removeField(String key) {
        this.fieldMap.remove(key);
    }

    public static boolean isOrganizationContactField(String fieldName) {
        return ORGANIZATION_CONTACT_FIELD_SET.contains(fieldName);
    }

    public static boolean isManifestPropertyField(String fieldName) {
        return MANIFEST_PROPERTY_FIELD_SET.contains(fieldName);
    }

    void prepareBilBagInfo(BagInfoTxt bagInfoTxt) {
        bagInfoTxt.clear();
        for (Map.Entry<String, BagInfoField> entry : this.fieldMap.entrySet()) {
            bagInfoTxt.put((Object)entry.getKey(), (Object)entry.getValue().getValue());
        }
        this.updateBagInfoTxtWithOrganizationInformation(bagInfoTxt);
    }

    private void updateBagInfoTxtWithOrganizationInformation(BagInfoTxt bagInfoTxt) {
        Contact contact;
        if (!this.sourceOrganization.getOrganizationName().trim().isEmpty()) {
            bagInfoTxt.setSourceOrganization(this.sourceOrganization.getOrganizationName().trim());
        }
        if (!this.sourceOrganization.getOrganizationAddress().trim().isEmpty()) {
            bagInfoTxt.setOrganizationAddress(this.sourceOrganization.getOrganizationAddress().trim());
        }
        if (!(contact = this.sourceOrganization.getContact()).getContactName().getFieldValue().trim().isEmpty()) {
            bagInfoTxt.setContactName(contact.getContactName().getFieldValue().trim());
        }
        if (!contact.getTelephone().getFieldValue().trim().isEmpty()) {
            bagInfoTxt.setContactPhone(contact.getTelephone().getFieldValue().trim());
        }
        if (!contact.getEmail().getFieldValue().trim().isEmpty()) {
            bagInfoTxt.setContactEmail(contact.getEmail().getFieldValue().trim());
        }
        if (!this.toContact.getContactName().getFieldValue().trim().isEmpty()) {
            bagInfoTxt.put((Object)"To-Contact-Name", (Object)this.toContact.getContactName().getFieldValue());
        }
        if (!this.toContact.getTelephone().getFieldValue().trim().isEmpty()) {
            bagInfoTxt.put((Object)"To-Contact-Phone", (Object)this.toContact.getTelephone().getFieldValue().trim());
        }
        if (!this.toContact.getEmail().getFieldValue().trim().isEmpty()) {
            bagInfoTxt.put((Object)"To-Contact-Email", (Object)this.toContact.getEmail().getFieldValue().trim());
        }
    }

    public Contact getToContact() {
        return this.toContact;
    }

    public void setToContact(Contact toContact) {
        this.toContact = toContact;
    }

    public void update(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (this.fieldMap.get(entry.getKey()) == null) continue;
            this.fieldMap.get(entry.getKey()).setValue(entry.getValue());
        }
    }
}

