/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.bag.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagHelper;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.utilities.namevalue.NameValueReader;
import gov.loc.repository.bagit.utilities.namevalue.impl.AbstractNameValueMapListBagFile;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ManifestPropertiesImpl
extends AbstractNameValueMapListBagFile
implements BagInfoTxt {
    public static final String FIELD_ATTRIBUTION = "Attribution";
    public static final String FIELD_LICENSE = "License";
    public static final String FIELD_LABEL = "Label";
    static final String FIELD_DESCRIPTION = "Description";
    public static final String FIELD_AUTHOR = "Author";
    public static final String FIELD_PUBLISHED = "Published";
    public static final String FIELD_INSTITUTION_LOGO_URI = "Logo URI";
    public static final String FIELD_RENDERING = "Rendering URI";
    static final String FIELD_RENDERING_LABEL = "Rendering Label";
    static final String FIELD_RENDERING_FORMAT = "Rendering MIME Type";
    private static final String FIELD_SOURCE_ORGANIZATION = "Source-Organization";
    private static final String FIELD_ORGANIZATION_ADDRESS = "Organization-Address";
    private static final String FIELD_CONTACT_NAME = "Contact-Name";
    private static final String FIELD_CONTACT_PHONE = "Contact-Phone";
    private static final String FIELD_CONTACT_EMAIL = "Contact-Email";
    private static final String FIELD_EXTERNAL_DESCRIPTION = "External-Description";
    private static final String FIELD_BAGGING_DATE = "Bagging-Date";
    private static final String FIELD_EXTERNAL_IDENTIFIER = "External-Identifier";
    private static final String FIELD_BAG_SIZE = "Bag-Size";
    private static final String FIELD_PAYLOAD_OXUM = "Payload-Oxum";
    private static final String FIELD_BAG_GROUP_IDENTIFIER = "Bag-Group-Identifier";
    private static final String FIELD_BAG_COUNT = "Bag-Count";
    private static final String FIELD_INTERNAL_SENDER_IDENTIFIER = "Internal-Sender-Identifier";
    private static final String FIELD_INTERNAL_SENDER_DESCRIPTION = "Internal-Sender-Description";
    private static final String STREAM_COUNT_PART = "Stream Count";
    private static final String OCTET_COUNT_PART = "Octet Count";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public ManifestPropertiesImpl(BagFile bagFile, Bag.BagConstants bagConstants) {
        super(bagConstants.getBagInfoTxt(), bagFile, bagConstants.getBagEncoding());
    }

    public ManifestPropertiesImpl(Bag.BagConstants bagConstants) {
        super(bagConstants.getBagInfoTxt(), bagConstants.getBagEncoding());
    }

    public String getBagCount() {
        return this.getCaseInsensitive(FIELD_BAG_COUNT);
    }

    public Integer getTotalBagsInGroup() throws ParseException {
        String bagCount = this.getBagCount();
        if (bagCount == null) {
            return null;
        }
        int pos = bagCount.indexOf(" of ");
        if (pos == -1 || pos + 4 >= bagCount.length()) {
            throw new ParseException("Bag-Count not structured N of T", 0);
        }
        String totalBags = bagCount.substring(pos + 4);
        if ("?".equals(totalBags)) {
            return -1;
        }
        try {
            return Integer.parseInt(totalBags);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Total Bags in Group is not an integer: " + totalBags, 0);
        }
    }

    public Integer getBagInGroup() throws ParseException {
        String bagCount = this.getBagCount();
        if (bagCount == null) {
            return null;
        }
        int pos = bagCount.indexOf(" of ");
        if (pos == -1 || pos - 1 < 0) {
            throw new ParseException("Bag-Count not structured N of T", 0);
        }
        String bagInGroup = bagCount.substring(0, pos);
        try {
            return Integer.parseInt(bagInGroup);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Bag in Group is not an integer: " + bagInGroup, 0);
        }
    }

    public String getAttribution() {
        return this.getCaseInsensitive(FIELD_ATTRIBUTION);
    }

    public String getBagGroupIdentifier() {
        return this.getCaseInsensitive(FIELD_BAG_GROUP_IDENTIFIER);
    }

    public String getBagSize() {
        return this.getCaseInsensitive(FIELD_BAG_SIZE);
    }

    public void generateBagSize(Bag bag) {
        this.setBagSize(BagHelper.generateBagSize((Bag)bag));
    }

    public String getBaggingDate() {
        return this.getCaseInsensitive(FIELD_BAGGING_DATE);
    }

    public Date getBaggingDateObj() throws ParseException {
        String baggingDate = this.getBaggingDate();
        if (baggingDate == null) {
            return null;
        }
        return this.dateFormat.parse(baggingDate);
    }

    public String getContactEmail() {
        return this.getCaseInsensitive(FIELD_CONTACT_EMAIL);
    }

    public String getContactName() {
        return this.getCaseInsensitive(FIELD_CONTACT_NAME);
    }

    public String getContactPhone() {
        return this.getCaseInsensitive(FIELD_CONTACT_PHONE);
    }

    public String getExternalDescription() {
        return this.getCaseInsensitive(FIELD_EXTERNAL_DESCRIPTION);
    }

    public String getExternalIdentifier() {
        return this.getCaseInsensitive(FIELD_EXTERNAL_IDENTIFIER);
    }

    public String getInternalSenderDescription() {
        return this.getCaseInsensitive(FIELD_INTERNAL_SENDER_DESCRIPTION);
    }

    public String getInternalSenderIdentifier() {
        return this.getCaseInsensitive(FIELD_INTERNAL_SENDER_IDENTIFIER);
    }

    public String getOrganizationAddress() {
        return this.getCaseInsensitive(FIELD_ORGANIZATION_ADDRESS);
    }

    public String getPayloadOxum() {
        return this.getCaseInsensitive(FIELD_PAYLOAD_OXUM);
    }

    public Long getOctetCount() throws ParseException {
        return this.getOxumPart(OCTET_COUNT_PART);
    }

    public Long getStreamCount() throws ParseException {
        return this.getOxumPart(STREAM_COUNT_PART);
    }

    private Long getOxumPart(String part) throws ParseException {
        String oxum = this.getPayloadOxum();
        if (oxum == null) {
            return null;
        }
        String[] split = oxum.split("\\.");
        if (split.length != 2) {
            throw new ParseException("Payload-Oxum is not OctetCount.StreamCount", 0);
        }
        int pos = 0;
        if (STREAM_COUNT_PART.equals(part)) {
            pos = 1;
        }
        try {
            return Long.parseLong(split[pos]);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(part + " is not an integer: " + split[pos], 0);
        }
    }

    public String getSourceOrganization() {
        return this.getCaseInsensitive(FIELD_SOURCE_ORGANIZATION);
    }

    public void setBagCount(String bagCount) {
        this.put(FIELD_BAG_COUNT, bagCount);
    }

    public void setBagCount(int bagInGroup, int totalBagsInGroup) {
        String totalBags = Integer.toString(totalBagsInGroup);
        if (totalBagsInGroup == -1) {
            totalBags = "?";
        }
        this.setBagCount(MessageFormat.format("{0} of {1}", Integer.toString(bagInGroup), totalBags));
    }

    public void setBagGroupIdentifier(String bagGroupIdentifier) {
        this.put(FIELD_BAG_GROUP_IDENTIFIER, bagGroupIdentifier);
    }

    public void setBagSize(String bagSize) {
        this.put(FIELD_BAG_SIZE, bagSize);
    }

    public void setBaggingDate(String baggingDate) {
        this.put(FIELD_BAGGING_DATE, baggingDate);
    }

    public void setBaggingDate(Date date) {
        String dateString = null;
        if (date != null) {
            dateString = this.dateFormat.format(date);
        }
        this.setBaggingDate(dateString);
    }

    public void setBaggingDate(int year, int month, int day) {
        try {
            this.setBaggingDate(this.dateFormat.parse(MessageFormat.format("{0}-{1}-{2}", Integer.toString(year), month, day)));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setContactEmail(String contactEmail) {
        this.put(FIELD_CONTACT_EMAIL, contactEmail);
    }

    public void setContactName(String contactName) {
        this.put(FIELD_CONTACT_NAME, contactName);
    }

    public void setContactPhone(String contactPhone) {
        this.put(FIELD_CONTACT_PHONE, contactPhone);
    }

    public void setExternalDescription(String externalDescription) {
        this.put(FIELD_EXTERNAL_DESCRIPTION, externalDescription);
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.put(FIELD_EXTERNAL_IDENTIFIER, externalIdentifier);
    }

    public void setInternalSenderDescription(String internalSenderDescription) {
        this.put(FIELD_INTERNAL_SENDER_DESCRIPTION, internalSenderDescription);
    }

    public void setInternalSenderIdentifier(String internalSenderIdentifier) {
        this.put(FIELD_INTERNAL_SENDER_IDENTIFIER, internalSenderIdentifier);
    }

    public void setOrganizationAddress(String organizationAddress) {
        this.put(FIELD_ORGANIZATION_ADDRESS, organizationAddress);
    }

    public void setPayloadOxum(String payloadOxsum) {
        this.put(FIELD_PAYLOAD_OXUM, payloadOxsum);
    }

    public void setPayloadOxum(long octetCount, long streamCount) {
        this.setPayloadOxum(Long.toString(octetCount) + "." + Long.toString(streamCount));
    }

    public void generatePayloadOxum(Bag bag) {
        this.setPayloadOxum(BagHelper.generatePayloadOctetCount((Bag)bag), bag.getPayload().size());
    }

    public void setSourceOrganization(String sourceOrganization) {
        this.put(FIELD_SOURCE_ORGANIZATION, sourceOrganization);
    }

    public String getType() {
        return "BagInfoTxt";
    }

    public boolean containsKeyCaseInsensitive(String key) {
        return this.getCaseInsensitive(key) != null;
    }

    private Collection<String> getActualKeys(String key) {
        ArrayList<String> actualKeys = new ArrayList<String>();
        for (String name : this.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            actualKeys.add(name);
        }
        return actualKeys;
    }

    public String getCaseInsensitive(String key) {
        for (Map.Entry entry : this.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(key)) continue;
            return (String)this.get(entry.getKey());
        }
        return null;
    }

    public List<String> getListCaseInsensitive(String key) {
        ArrayList<String> values = new ArrayList<String>();
        for (NameValueReader.NameValue nameValue : this.nameValueList) {
            if (!nameValue.getName().equalsIgnoreCase(key)) continue;
            values.add(nameValue.getValue());
        }
        return values;
    }

    public List<String> getStandardFields() {
        ArrayList<String> standardFields = new ArrayList<String>();
        Field[] fields = ((Object)((Object)this)).getClass().getFields();
        try {
            for (Field field : fields) {
                if (!field.getName().startsWith("FIELD_") || !this.containsKeyCaseInsensitive((String)field.get((Object)this))) continue;
                standardFields.addAll(this.getActualKeys((String)field.get((Object)this)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return standardFields;
    }

    public List<String> getNonstandardFields() {
        List<String> standardFields = this.getStandardFields();
        ArrayList<String> nonstandardFields = new ArrayList<String>();
        for (String key : this.keySet()) {
            if (standardFields.contains(key)) continue;
            nonstandardFields.add(key);
        }
        return nonstandardFields;
    }

    public void addBagGroupIdentifier(String bagGroupIdentifier) {
        this.putList(FIELD_BAG_GROUP_IDENTIFIER, bagGroupIdentifier);
    }

    public void addContactEmail(String contactEmail) {
        this.putList(FIELD_CONTACT_EMAIL, contactEmail);
    }

    public void addContactName(String contactName) {
        this.putList(FIELD_CONTACT_NAME, contactName);
    }

    public void addContactPhone(String contactPhone) {
        this.putList(FIELD_CONTACT_PHONE, contactPhone);
    }

    public void addExternalDescription(String externalDescription) {
        this.putList(FIELD_EXTERNAL_DESCRIPTION, externalDescription);
    }

    public void addExternalIdentifier(String externalIdentifier) {
        this.putList(FIELD_EXTERNAL_IDENTIFIER, externalIdentifier);
    }

    public void addInternalSenderDescription(String internalSenderDescription) {
        this.putList(FIELD_INTERNAL_SENDER_DESCRIPTION, internalSenderDescription);
    }

    public void addInternalSenderIdentifier(String internalSenderIdentifier) {
        this.putList(FIELD_INTERNAL_SENDER_IDENTIFIER, internalSenderIdentifier);
    }

    public void addOrganizationAddress(String organizationAddress) {
        this.putList(FIELD_ORGANIZATION_ADDRESS, organizationAddress);
    }

    public void addSourceOrganization(String sourceOrganization) {
        this.putList(FIELD_SOURCE_ORGANIZATION, sourceOrganization);
    }

    public List<String> getBagGroupIdentifierList() {
        return this.getListCaseInsensitive(FIELD_BAG_GROUP_IDENTIFIER);
    }

    public List<String> getContactEmailList() {
        return this.getListCaseInsensitive(FIELD_CONTACT_EMAIL);
    }

    public List<String> getContactNameList() {
        return this.getListCaseInsensitive(FIELD_CONTACT_NAME);
    }

    public List<String> getContactPhoneList() {
        return this.getListCaseInsensitive(FIELD_CONTACT_PHONE);
    }

    public List<String> getExternalDescriptionList() {
        return this.getListCaseInsensitive(FIELD_EXTERNAL_DESCRIPTION);
    }

    public List<String> getExternalIdentifierList() {
        return this.getListCaseInsensitive(FIELD_EXTERNAL_IDENTIFIER);
    }

    public List<String> getInternalSenderDescriptionList() {
        return this.getListCaseInsensitive(FIELD_INTERNAL_SENDER_DESCRIPTION);
    }

    public List<String> getInternalSenderIdentifierList() {
        return this.getListCaseInsensitive(FIELD_INTERNAL_SENDER_IDENTIFIER);
    }

    public List<String> getOrganizationAddressList() {
        return this.getListCaseInsensitive(FIELD_ORGANIZATION_ADDRESS);
    }

    public List<String> getSourceOrganizationList() {
        return this.getListCaseInsensitive(FIELD_SOURCE_ORGANIZATION);
    }
}

