/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.profile;

import cool.pandora.modeller.Bagger;
import cool.pandora.modeller.Profile;
import cool.pandora.modeller.ProfileField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BaggerProfileStore {
    private static BaggerProfileStore instance;
    private HashMap<String, Profile> userProfiles = new HashMap();
    private LinkedHashMap<String, List<ProfileField>> profileFieldsMap = new LinkedHashMap();

    public BaggerProfileStore(Bagger bagger) {
        this.initializeProfile(bagger);
        instance = this;
    }

    public Profile getProfile(String name) {
        Profile profile = this.userProfiles.get(name);
        if (profile == null) {
            throw new RuntimeException("Could not get profile [" + name + "]");
        }
        return profile;
    }

    private void initializeProfile(Bagger bagger) {
        List profiles = bagger.loadProfiles();
        this.userProfiles = new HashMap();
        this.profileFieldsMap = new LinkedHashMap();
        for (Profile profile : profiles) {
            this.userProfiles.put(profile.getName(), profile);
            LinkedHashMap standardFields = profile.getStandardFields();
            LinkedHashMap customFields = profile.getCustomFields();
            LinkedHashMap mergedMap = new LinkedHashMap();
            mergedMap.putAll(standardFields);
            mergedMap.putAll(customFields);
            for (ProfileField profileField : mergedMap.values()) {
                List list = this.profileFieldsMap.computeIfAbsent(profile.getName(), k -> new ArrayList());
                list.add(profileField);
            }
        }
    }

    public Profile getDefaultProfile() {
        for (Map.Entry<String, Profile> entry : this.userProfiles.entrySet()) {
            if (!entry.getValue().getIsDefault()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static BaggerProfileStore getInstance() {
        return instance;
    }

    public String[] getProfileNames() {
        return this.userProfiles.keySet().toArray(new String[0]);
    }

    public List<ProfileField> getProfileFields(String profileName) {
        return this.profileFieldsMap.get(profileName);
    }
}

