/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.form.FieldMetadata;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.support.CommitListenerAdapter;
import org.springframework.binding.value.support.AbstractPropertyChangePublisher;
import org.springframework.binding.value.support.DirtyTrackingValueModel;

public class DefaultFieldMetadata
extends AbstractPropertyChangePublisher
implements FieldMetadata {
    private final FormModel formModel;
    private final DirtyTrackingValueModel valueModel;
    private final Class propertyType;
    private final boolean forceReadOnly;
    private final Map userMetadata = new HashMap();
    private boolean oldReadOnly;
    private boolean readOnly;
    private boolean enabled = true;
    private boolean oldEnabled = true;
    private final DirtyChangeHandler dirtyChangeHandler = new DirtyChangeHandler();
    private final PropertyChangeListener formChangeHandler = new FormModelChangeHandler();

    public DefaultFieldMetadata(FormModel formModel, DirtyTrackingValueModel valueModel, Class propertyType, boolean forceReadOnly, Map userMetadata) {
        this.formModel = formModel;
        this.valueModel = valueModel;
        this.valueModel.addPropertyChangeListener("dirty", this.dirtyChangeHandler);
        this.propertyType = propertyType;
        this.forceReadOnly = forceReadOnly;
        this.formModel.addPropertyChangeListener("enabled", this.formChangeHandler);
        this.formModel.addPropertyChangeListener("readOnly", this.formChangeHandler);
        this.oldReadOnly = this.isReadOnly();
        this.oldEnabled = this.isEnabled();
        if (userMetadata != null) {
            this.userMetadata.putAll(userMetadata);
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.firePropertyChange("readOnly", this.oldReadOnly, this.isReadOnly());
        this.oldReadOnly = this.isReadOnly();
    }

    public boolean isReadOnly() {
        return this.forceReadOnly || this.readOnly || this.formModel.isReadOnly();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.firePropertyChange("enabled", this.oldEnabled, this.isEnabled());
        this.oldEnabled = this.isEnabled();
    }

    public boolean isEnabled() {
        return this.enabled && this.formModel.isEnabled();
    }

    public boolean isDirty() {
        return this.valueModel.isDirty();
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Object getUserMetadata(String key) {
        return this.userMetadata.get(key);
    }

    public Map getAllUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(String key, Object value) {
        Object old = this.userMetadata.put(key, value);
        this.firePropertyChange(key, old, value);
    }

    public void clearUserMetadata() {
        Object[] keys = this.userMetadata.keySet().toArray();
        for (int i = keys.length - 1; i >= 0; --i) {
            Object old = this.userMetadata.remove(keys[i]);
            if (old == null) continue;
            this.firePropertyChange((String)keys[i], old, null);
        }
    }

    private class FormModelChangeHandler
    implements PropertyChangeListener {
        private FormModelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                DefaultFieldMetadata.this.firePropertyChange("enabled", DefaultFieldMetadata.this.oldEnabled, DefaultFieldMetadata.this.isEnabled());
                DefaultFieldMetadata.this.oldEnabled = DefaultFieldMetadata.this.isEnabled();
            } else if ("readOnly".equals(evt.getPropertyName())) {
                DefaultFieldMetadata.this.firePropertyChange("readOnly", DefaultFieldMetadata.this.oldReadOnly, DefaultFieldMetadata.this.isReadOnly());
                DefaultFieldMetadata.this.oldReadOnly = DefaultFieldMetadata.this.isReadOnly();
            }
        }
    }

    private class DirtyChangeHandler
    extends CommitListenerAdapter
    implements PropertyChangeListener {
        private DirtyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DefaultFieldMetadata.this.firePropertyChange("dirty", evt.getOldValue(), evt.getNewValue());
        }
    }
}

