/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.springframework.binding.value.ValueChangeDetector;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractValueModelWrapper;
import org.springframework.binding.value.support.DirtyTrackingValueModel;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.util.EventListenerListHelper;

public class FormModelMediatingValueModel
extends AbstractValueModelWrapper
implements DirtyTrackingValueModel,
PropertyChangeListener {
    private final EventListenerListHelper dirtyChangeListeners = new EventListenerListHelper(PropertyChangeListener.class);
    private boolean deliverValueChangeEvents = true;
    private final ValueHolder mediatedValueHolder;
    private Object originalValue;
    private boolean oldDirty;
    private final boolean trackDirty;
    private ValueChangeDetector valueChangeDetector;

    public FormModelMediatingValueModel(ValueModel propertyValueModel) {
        this(propertyValueModel, true);
    }

    public FormModelMediatingValueModel(ValueModel propertyValueModel, boolean trackDirty) {
        super(propertyValueModel);
        super.addValueChangeListener(this);
        this.originalValue = this.getValue();
        this.mediatedValueHolder = new ValueHolder(this.originalValue);
        this.trackDirty = trackDirty;
    }

    public void setValueSilently(Object value, PropertyChangeListener listenerToSkip) {
        super.setValueSilently(value, this);
        if (this.deliverValueChangeEvents) {
            this.mediatedValueHolder.setValueSilently(value, listenerToSkip);
            this.updateDirtyState();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.originalValue = this.getValue();
        if (this.deliverValueChangeEvents) {
            this.mediatedValueHolder.setValue(this.originalValue);
            this.updateDirtyState();
        }
    }

    public void setDeliverValueChangeEvents(boolean deliverValueChangeEvents) {
        boolean oldDeliverValueChangeEvents = this.deliverValueChangeEvents;
        this.deliverValueChangeEvents = deliverValueChangeEvents;
        if (!oldDeliverValueChangeEvents && deliverValueChangeEvents) {
            this.mediatedValueHolder.setValue(this.getValue());
            this.updateDirtyState();
        }
    }

    public boolean isDirty() {
        return this.trackDirty && this.getValueChangeDetector().hasValueChanged(this.originalValue, this.getValue());
    }

    public void clearDirty() {
        if (this.isDirty()) {
            this.originalValue = this.getValue();
            this.updateDirtyState();
        }
    }

    public void revertToOriginal() {
        if (this.isDirty()) {
            this.setValue(this.originalValue);
        }
    }

    protected void updateDirtyState() {
        boolean dirty = this.isDirty();
        if (this.oldDirty != dirty) {
            this.oldDirty = dirty;
            this.firePropertyChange("dirty", !dirty, dirty);
        }
    }

    public void setValueChangeDetector(ValueChangeDetector valueChangeDetector) {
        this.valueChangeDetector = valueChangeDetector;
    }

    protected ValueChangeDetector getValueChangeDetector() {
        if (this.valueChangeDetector == null) {
            this.valueChangeDetector = (ValueChangeDetector)ApplicationServicesLocator.services().getService(ValueChangeDetector.class);
        }
        return this.valueChangeDetector;
    }

    public void addValueChangeListener(PropertyChangeListener listener) {
        this.mediatedValueHolder.addValueChangeListener(listener);
    }

    public void removeValueChangeListener(PropertyChangeListener listener) {
        this.mediatedValueHolder.removeValueChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if ("dirty".equals(propertyName)) {
            this.dirtyChangeListeners.add(listener);
        } else if ("value".equals(propertyName)) {
            this.addValueChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if ("dirty".equals(propertyName)) {
            this.dirtyChangeListeners.remove(listener);
        } else if ("value".equals(propertyName)) {
            this.removeValueChangeListener(listener);
        }
    }

    protected final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if ("dirty".equals(propertyName)) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            Iterator i = this.dirtyChangeListeners.iterator();
            while (i.hasNext()) {
                ((PropertyChangeListener)i.next()).propertyChange(evt);
            }
        }
    }
}

