/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import javax.swing.Icon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.form.FieldFace;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.support.CachingFieldFaceSource;
import org.springframework.binding.form.support.DefaultFieldFace;
import org.springframework.binding.form.support.DefaultMessageCodeStrategy;
import org.springframework.binding.form.support.MessageCodeStrategy;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.core.LabelInfo;
import org.springframework.richclient.image.IconSource;

public class MessageSourceFieldFaceSource
extends CachingFieldFaceSource {
    private static final Log log = LogFactory.getLog(MessageSourceFieldFaceSource.class);
    private static final String[] DISPLAY_NAME_PROPERTY = new String[]{"displayName"};
    private static final String[] CAPTION_PROPERTY = new String[]{"caption"};
    private static final String[] DESCRIPTION_PROPERTY = new String[]{"description"};
    private static final String[] ENCODED_LABEL_PROPERTY = new String[]{"label", ""};
    private static final String[] ICON_PROPERTY = new String[]{"icon"};
    private MessageSourceAccessor messageSourceAccessor;
    private MessageCodeStrategy messageKeyStrategy;
    private IconSource iconSource;
    private final ReflectiveVisitorHelper visitorHelper = new ReflectiveVisitorHelper();

    public void setMessageSourceAccessor(MessageSourceAccessor messageSourceAccessor) {
        this.messageSourceAccessor = messageSourceAccessor;
    }

    protected MessageSourceAccessor getMessageSourceAccessor() {
        if (this.messageSourceAccessor == null) {
            this.messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        return this.messageSourceAccessor;
    }

    public void setIconSource(IconSource iconSource) {
        this.iconSource = iconSource;
    }

    protected IconSource getIconSource() {
        if (this.iconSource == null) {
            this.iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        }
        return this.iconSource;
    }

    protected String getMessage(String contextId, String fieldPath, String[] faceDescriptorProperty) {
        String[] keys = this.getMessageKeys(contextId, fieldPath, faceDescriptorProperty);
        return this.getMessageSourceAccessor().getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(keys, null, keys[0]));
    }

    protected String getMessage(String contextId, String fieldPath, String[] faceDescriptorProperties, String defaultValue) {
        String[] keys = this.getMessageKeys(contextId, fieldPath, faceDescriptorProperties);
        try {
            return this.getMessageSourceAccessor().getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(keys, null, defaultValue));
        }
        catch (NoSuchMessageException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return null;
        }
    }

    protected String[] getMessageKeys(String contextId, String fieldPath, String[] faceDescriptorProperties) {
        return this.getMessageKeyStrategy().getMessageCodes(contextId, fieldPath, faceDescriptorProperties);
    }

    protected FieldFace loadFieldFace(String field, String contextId) {
        String caption = this.getMessage(contextId, field, CAPTION_PROPERTY, null);
        String description = this.getMessage(contextId, field, DESCRIPTION_PROPERTY, null);
        String encodedLabel = this.getMessage(contextId, field, ENCODED_LABEL_PROPERTY);
        if (encodedLabel == null) {
            encodedLabel = this.getMessage(contextId, field, null);
        }
        String iconName = this.getMessage(contextId, field, ICON_PROPERTY, null);
        Icon icon = null;
        if (iconName != null) {
            icon = this.getIconSource().getIcon(iconName);
        }
        LabelInfo labelInfo = LabelInfo.valueOf(encodedLabel);
        String displayName = this.getMessage(contextId, field, DISPLAY_NAME_PROPERTY, labelInfo.getText());
        return new DefaultFieldFace(displayName, caption, description, labelInfo, icon);
    }

    protected FieldFace loadFieldFace(String field, Object context) {
        String contextId = (String)this.visitorHelper.invokeVisit((Object)this, context);
        return this.loadFieldFace(field, contextId);
    }

    public MessageCodeStrategy getMessageKeyStrategy() {
        if (this.messageKeyStrategy == null) {
            this.messageKeyStrategy = new DefaultMessageCodeStrategy();
        }
        return this.messageKeyStrategy;
    }

    public void setMessageKeyStrategy(MessageCodeStrategy messageKeyStrategy) {
        this.messageKeyStrategy = messageKeyStrategy;
    }

    String visit(FormModel formModel) {
        return formModel.getId();
    }

    String visit(CharSequence contextId) {
        return ((Object)contextId).toString();
    }

    String visitNull() {
        return null;
    }
}

