/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.time.DateFormatUtils;

public class NestedPropertyChangeListener
implements PropertyChangeListener {
    private JTextField nestedField;
    private String nestedProperty;
    private static BeanUtilsBean beanUtilsBean;

    public NestedPropertyChangeListener(JTextField nestedPropertyField, String nestedProperty) {
        this.nestedField = nestedPropertyField;
        this.nestedProperty = nestedProperty;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (newValue == null) {
            this.nestedField.setText("");
        } else {
            String nestedValue;
            try {
                nestedValue = beanUtilsBean.getProperty(newValue, this.nestedProperty);
            }
            catch (Exception ex) {
                nestedValue = "";
            }
            this.nestedField.setText(nestedValue);
            this.nestedField.setToolTipText(nestedValue);
        }
        this.nestedField.select(0, 0);
    }

    static {
        ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
        convertUtilsBean.register((Converter)new StringConverter(), String.class);
        beanUtilsBean = new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());
    }

    public static final class StringConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                return DateFormatUtils.format((Date)((Date)value), (String)"dd/MM/yyyy");
            }
            return value.toString();
        }
    }
}

