/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.springframework.binding.support.AnnotationTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionAnnotationTranslator
implements AnnotationTranslator {
    public static final String SINGLE_VALUE_METHOD_NAME = "value";

    @Override
    public void translate(Annotation annotation, Map<String, Object> result) {
        try {
            Class<? extends Annotation> type = annotation.annotationType();
            Method[] methods = type.getDeclaredMethods();
            String name = type.getName();
            result.put("@" + name, annotation);
            if (methods.length == 0) {
                result.put(name, Boolean.TRUE);
            } else if (methods.length == 1 && SINGLE_VALUE_METHOD_NAME.equals(methods[0].getName())) {
                result.put(name, methods[0].invoke((Object)annotation, new Object[0]));
            } else {
                result.put(name, Boolean.TRUE);
                for (Method method : methods) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    result.put(name + "." + method.getName(), method.invoke((Object)annotation, new Object[0]));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

