/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.validation.support;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.MessageInterpolator;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.validation.RichValidator;
import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResults;
import org.springframework.binding.validation.support.DefaultValidationMessage;
import org.springframework.binding.validation.support.DefaultValidationResults;
import org.springframework.binding.validation.support.HibernateRulesMessageInterpolator;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.util.Assert;
import org.springframework.rules.reporting.ObjectNameResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateRulesValidator
implements RichValidator,
ObjectNameResolver {
    private final ClassValidator hibernateValidator;
    private ValidatingFormModel formModel;
    private DefaultValidationResults results = new DefaultValidationResults();
    private Set<String> ignoredHibernateProperties;

    public HibernateRulesValidator(ValidatingFormModel formModel, Class clazz) {
        this(formModel, clazz, new HashSet<String>());
    }

    public HibernateRulesValidator(ValidatingFormModel formModel, Class clazz, Set<String> ignoredHibernateProperties) {
        this.formModel = formModel;
        this.hibernateValidator = new ClassValidator(clazz, (MessageInterpolator)new HibernateRulesMessageInterpolator());
        this.ignoredHibernateProperties = ignoredHibernateProperties;
    }

    @Override
    public ValidationResults validate(Object object) {
        return this.validate(object, null);
    }

    @Override
    public ValidationResults validate(Object object, String propertyName) {
        if (propertyName == null) {
            this.results.clearMessages();
        } else {
            this.results.clearMessages(propertyName);
        }
        this.addInvalidValues(this.doHibernateValidate(object, propertyName));
        return this.results;
    }

    protected void addInvalidValues(InvalidValue[] invalidValues) {
        if (invalidValues != null) {
            for (InvalidValue invalidValue : invalidValues) {
                this.results.addMessage(this.translateMessage(invalidValue));
            }
        }
    }

    protected ValidationMessage translateMessage(InvalidValue invalidValue) {
        return new DefaultValidationMessage(invalidValue.getPropertyName(), Severity.ERROR, this.resolveObjectName(invalidValue.getPropertyName()) + " " + invalidValue.getMessage());
    }

    protected InvalidValue[] doHibernateValidate(Object object, String property) {
        if (property == null) {
            PropertyDescriptor[] propertyDescriptors;
            ArrayList<InvalidValue> ret = new ArrayList<InvalidValue>();
            try {
                propertyDescriptors = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("Could not retrieve property information");
            }
            for (PropertyDescriptor prop : propertyDescriptors) {
                InvalidValue[] result;
                String propertyName = prop.getName();
                if (!this.formModel.hasValueModel(propertyName) || this.ignoredHibernateProperties.contains(propertyName) || (result = this.hibernateValidator.getPotentialInvalidValues(propertyName, this.formModel.getValueModel(propertyName).getValue())) == null) continue;
                for (InvalidValue r : result) {
                    ret.add(r);
                }
            }
            return ret.toArray(new InvalidValue[ret.size()]);
        }
        if (!this.ignoredHibernateProperties.contains(property) && this.formModel.hasValueModel(property)) {
            return this.hibernateValidator.getPotentialInvalidValues(property, this.formModel.getValueModel(property).getValue());
        }
        return null;
    }

    public void clearMessages() {
        this.results.clearMessages();
    }

    public void addIgnoredHibernateProperty(String propertyName) {
        Assert.notNull((Object)propertyName);
        this.ignoredHibernateProperties.add(propertyName);
    }

    public void removeIgnoredHibernateProperty(String propertyName) {
        Assert.notNull((Object)propertyName);
        this.ignoredHibernateProperties.remove(propertyName);
    }

    @Override
    public String resolveObjectName(String objectName) {
        return this.formModel.getFieldFace(objectName).getDisplayName();
    }
}

