/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.BufferedValueModel;
import org.springframework.binding.value.support.ListListModel;
import org.springframework.binding.value.support.ObservableList;
import org.springframework.richclient.util.ClassUtils;
import org.springframework.util.Assert;

public class BufferedCollectionValueModel
extends BufferedValueModel {
    private final ListChangeHandler listChangeHandler = new ListChangeHandler();
    private final Class wrappedType;
    private final Class wrappedConcreteType;
    private ObservableList bufferedListModel;

    public BufferedCollectionValueModel(ValueModel wrappedModel, Class wrappedType) {
        super(wrappedModel);
        Assert.notNull((Object)wrappedType);
        this.wrappedType = wrappedType;
        this.wrappedConcreteType = BufferedCollectionValueModel.getConcreteCollectionType(wrappedType);
        this.updateBufferedListModel(this.getWrappedValue());
        if (this.getValue() != this.bufferedListModel) {
            super.setValue(this.bufferedListModel);
        }
    }

    public void setValue(Object value) {
        if (value != this.bufferedListModel && !this.hasSameStructure()) {
            this.updateBufferedListModel(value);
            this.fireValueChange(this.bufferedListModel, this.bufferedListModel);
        }
    }

    protected Object getValueToCommit() {
        Object wrappedValue = this.getWrappedValue();
        if (wrappedValue == null && this.bufferedListModel.size() == 0) {
            return null;
        }
        return this.createCollection(wrappedValue);
    }

    public static Class getConcreteCollectionType(Class wrappedType) {
        Class class2Create;
        if (wrappedType.isArray()) {
            if (ClassUtils.isPrimitiveArray(wrappedType)) {
                throw new IllegalArgumentException("wrappedType can not be an array of primitive types");
            }
            class2Create = wrappedType;
        } else if (wrappedType == Collection.class) {
            class2Create = ArrayList.class;
        } else if (wrappedType == List.class) {
            class2Create = ArrayList.class;
        } else if (wrappedType == Set.class) {
            class2Create = HashSet.class;
        } else if (wrappedType == SortedSet.class) {
            class2Create = TreeSet.class;
        } else if (Collection.class.isAssignableFrom(wrappedType)) {
            if (wrappedType.isInterface()) {
                throw new IllegalArgumentException("unable to handle Collection of type [" + wrappedType + "]. Do not know how to create a concrete implementation");
            }
            class2Create = wrappedType;
        } else {
            throw new IllegalArgumentException("wrappedType [" + wrappedType + "] must be an array or a Collection");
        }
        return class2Create;
    }

    private boolean hasSameStructure() {
        Object wrappedCollection = this.getWrappedValue();
        if (wrappedCollection == null) {
            return this.bufferedListModel.size() == 0;
        }
        if (wrappedCollection instanceof Object[]) {
            Object[] wrappedArray = (Object[])wrappedCollection;
            if (wrappedArray.length != this.bufferedListModel.size()) {
                return false;
            }
            for (int i = 0; i < this.bufferedListModel.size(); ++i) {
                if (!super.hasValueChanged(wrappedArray[i], this.bufferedListModel.get(i))) continue;
                return false;
            }
        } else {
            if (((Collection)wrappedCollection).size() != this.bufferedListModel.size()) {
                return false;
            }
            Iterator i = ((Collection)wrappedCollection).iterator();
            Iterator j = this.bufferedListModel.iterator();
            while (i.hasNext()) {
                if (!super.hasValueChanged(i.next(), j.next())) continue;
                return false;
            }
        }
        return true;
    }

    private Object createCollection(Object wrappedCollection) {
        return this.populateFromListModel(this.createNewCollection(wrappedCollection));
    }

    private Object createNewCollection(Object wrappedCollection) {
        Object newCollection;
        if (this.wrappedConcreteType.isArray()) {
            return Array.newInstance(this.wrappedConcreteType.getComponentType(), this.bufferedListModel.size());
        }
        if (SortedSet.class.isAssignableFrom(this.wrappedConcreteType) && wrappedCollection instanceof SortedSet && ((SortedSet)wrappedCollection).comparator() != null) {
            try {
                Constructor con = this.wrappedConcreteType.getConstructor(Comparator.class);
                newCollection = BeanUtils.instantiateClass(con, (Object[])new Object[]{((SortedSet)wrappedCollection).comparator()});
            }
            catch (NoSuchMethodException e) {
                throw new FatalBeanException("Could not instantiate SortedSet class [" + this.wrappedConcreteType.getName() + "]: no constructor taking Comparator found", (Throwable)e);
            }
        } else {
            newCollection = BeanUtils.instantiateClass((Class)this.wrappedConcreteType);
        }
        return newCollection;
    }

    private Object populateFromListModel(Object collection) {
        if (collection instanceof Object[]) {
            Object[] wrappedArray = (Object[])collection;
            for (int i = 0; i < this.bufferedListModel.size(); ++i) {
                wrappedArray[i] = this.bufferedListModel.get(i);
            }
        } else {
            Collection wrappedCollection = (Collection)collection;
            wrappedCollection.clear();
            wrappedCollection.addAll(this.bufferedListModel);
        }
        return collection;
    }

    protected ObservableList createBufferedListModel() {
        return new ListListModel();
    }

    private Object updateBufferedListModel(Object wrappedCollection) {
        if (this.bufferedListModel == null) {
            this.bufferedListModel = this.createBufferedListModel();
            this.bufferedListModel.addListDataListener(this.listChangeHandler);
            this.setValue(this.bufferedListModel);
        }
        if (wrappedCollection == null) {
            this.bufferedListModel.clear();
        } else if (this.wrappedType.isAssignableFrom(wrappedCollection.getClass())) {
            List<Object> buffer = null;
            if (wrappedCollection instanceof Object[]) {
                Object[] wrappedArray = (Object[])wrappedCollection;
                buffer = Arrays.asList(wrappedArray);
            } else {
                buffer = (List<Object>)wrappedCollection;
            }
            this.bufferedListModel.clear();
            this.bufferedListModel.addAll(this.prepareBackingCollection(buffer));
        } else {
            throw new IllegalArgumentException("wrappedCollection must be assignable from " + this.wrappedType.getName());
        }
        return this.bufferedListModel;
    }

    protected Collection prepareBackingCollection(Collection col) {
        return col;
    }

    private Object getWrappedValue() {
        return this.getWrappedValueModel().getValue();
    }

    protected void fireListModelChanged() {
        if (this.isBuffering()) {
            super.fireValueChange(this.bufferedListModel, this.bufferedListModel);
        } else {
            super.setValue(this.bufferedListModel);
        }
    }

    protected boolean hasValueChanged(Object oldValue, Object newValue) {
        return oldValue == this.bufferedListModel && newValue == this.bufferedListModel || super.hasValueChanged(oldValue, newValue);
    }

    private class ListChangeHandler
    implements ListDataListener {
        private ListChangeHandler() {
        }

        public void contentsChanged(ListDataEvent e) {
            BufferedCollectionValueModel.this.fireListModelChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            BufferedCollectionValueModel.this.fireListModelChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            BufferedCollectionValueModel.this.fireListModelChanged();
        }
    }
}

