/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import org.springframework.binding.value.IndexAdapter;
import org.springframework.binding.value.support.AbstractIndexAdapter;
import org.springframework.binding.value.support.ObservableList;
import org.springframework.util.ObjectUtils;

public class ListListModel
extends AbstractListModel
implements ObservableList {
    private List items;
    private Comparator sorter;
    private IndexAdapter indexAdapter;

    public ListListModel() {
        this(null);
    }

    public ListListModel(List items) {
        this(items, null);
    }

    public ListListModel(List items, Comparator sorter) {
        this.items = items != null ? new ArrayList(items) : new ArrayList();
        this.setComparator(sorter);
        this.sort();
    }

    public void setComparator(Comparator sorter) {
        this.sorter = sorter;
    }

    public void sort() {
        if (this.sorter != null) {
            Collections.sort(this.items, this.sorter);
            this.fireContentsChanged(this.items, -1, -1);
        }
    }

    protected List getItems() {
        return this.items;
    }

    public int getSize() {
        return this.items.size();
    }

    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    public void add(int index, Object o) {
        this.items.add(index, o);
        this.fireIntervalAdded(this, index, index);
    }

    public IndexAdapter getIndexAdapter(int index) {
        if (this.indexAdapter == null) {
            this.indexAdapter = new ThisIndexAdapter();
        }
        this.indexAdapter.setIndex(index);
        return this.indexAdapter;
    }

    public boolean add(Object o) {
        boolean result = this.items.add(o);
        if (result) {
            int end = this.items.size() - 1;
            this.fireIntervalAdded(this, end, end);
        }
        return result;
    }

    public boolean addAll(Collection c) {
        int firstIndex = this.items.size();
        boolean result = this.items.addAll(c);
        if (result) {
            int lastIndex = this.items.size() - 1;
            this.fireIntervalAdded(this, firstIndex, lastIndex);
        }
        return result;
    }

    public boolean addAll(int index, Collection c) {
        boolean result = this.items.addAll(index, c);
        if (result) {
            this.fireIntervalAdded(this, index, index + c.size() - 1);
        }
        return result;
    }

    public void clear() {
        if (this.items.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.items.size() - 1;
            this.items.clear();
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.items.containsAll(c);
    }

    public Object get(int index) {
        return this.items.get(index);
    }

    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Iterator iterator() {
        return this.items.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.items.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.items.listIterator(index);
    }

    public Object remove(int index) {
        Object o = this.items.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return o;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index != -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        boolean b = this.items.removeAll(c);
        if (b) {
            this.fireContentsChanged(this, -1, -1);
        }
        return b;
    }

    public boolean retainAll(Collection c) {
        boolean b = this.items.retainAll(c);
        if (b) {
            this.fireContentsChanged(this, -1, -1);
        }
        return b;
    }

    public Object set(int index, Object element) {
        Object oldObject = this.items.set(index, element);
        if (this.hasChanged(oldObject, element)) {
            this.fireContentsChanged(index);
        }
        return oldObject;
    }

    protected boolean hasChanged(Object oldElement, Object newElement) {
        return !ObjectUtils.nullSafeEquals((Object)oldElement, (Object)newElement);
    }

    public int size() {
        return this.items.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.items.toArray(a);
    }

    protected void fireContentsChanged(int index) {
        this.fireContentsChanged(index, index);
    }

    protected void fireContentsChanged(int startIndex, int endIndex) {
        this.fireContentsChanged(this, startIndex, endIndex);
    }

    public boolean replaceWith(Collection collection) {
        boolean changed = false;
        if (this.items.size() > 0) {
            this.items.clear();
            changed = true;
        }
        if (this.items.addAll(0, collection) && !changed) {
            changed = true;
        }
        if (changed) {
            this.fireContentsChanged(-1, -1);
        }
        return changed;
    }

    private class ThisIndexAdapter
    extends AbstractIndexAdapter {
        private static final int NULL_INDEX = -1;

        private ThisIndexAdapter() {
        }

        public Object getValue() {
            if (this.getIndex() == -1) {
                return null;
            }
            return ListListModel.this.get(this.getIndex());
        }

        public void setValue(Object value) {
            if (this.getIndex() == -1) {
                throw new IllegalStateException("Attempt to set value at null index; operation not allowed");
            }
            Object oldValue = ListListModel.this.items.set(this.getIndex(), value);
            if (this.hasValueChanged(oldValue, value)) {
                ListListModel.this.fireContentsChanged(this.getIndex());
                this.fireValueChange(oldValue, value);
            }
        }

        public void fireIndexedObjectChanged() {
            ListListModel.this.fireContentsChanged(this.getIndex());
        }
    }
}

