/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import org.springframework.binding.value.ValueModel;

public class SelectableButtonModelAdapter
extends DefaultButtonModel
implements PropertyChangeListener {
    private final ValueModel valueModel;

    public SelectableButtonModelAdapter(ValueModel valueModel) {
        this.valueModel = valueModel;
        this.valueModel.addValueChangeListener(this);
        this.propertyChange(null);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Boolean selected = (Boolean)this.valueModel.getValue();
        this.setSelected(selected == null ? false : selected);
    }

    public void setPressed(boolean pressed) {
        if (this.isPressed() == pressed || !this.isEnabled()) {
            return;
        }
        if (!pressed && this.isArmed()) {
            this.setSelected(!this.isSelected());
        }
        super.setPressed(pressed);
    }

    public void setSelected(boolean selected) {
        if (this.isSelected() == selected) {
            return;
        }
        super.setSelected(selected);
        this.valueModel.setValue(this.isSelected());
    }
}

