/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ProgressMonitoringBeanFactoryPostProcessor;
import org.springframework.richclient.application.splash.MonitoringSplashScreen;
import org.springframework.richclient.application.splash.SplashScreen;
import org.springframework.richclient.progress.ProgressMonitor;
import org.springframework.richclient.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationLauncher {
    public static final String SPLASH_SCREEN_BEAN_ID = "splashScreen";
    public static final String APPLICATION_BEAN_ID = "application";
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext startupContext;
    private SplashScreen splashScreen;
    private ApplicationContext rootApplicationContext;

    public ApplicationLauncher(String rootContextPath) {
        this(new String[]{rootContextPath});
    }

    public ApplicationLauncher(String[] rootContextConfigLocations) {
        this(null, rootContextConfigLocations);
    }

    public ApplicationLauncher(String startupContextPath, String rootContextPath) {
        this(startupContextPath, new String[]{rootContextPath});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationLauncher(String startupContextPath, String[] rootContextConfigLocations) {
        Assert.noElementsNull(rootContextConfigLocations, "rootContextConfigLocations");
        Assert.notEmpty((Object[])rootContextConfigLocations, (String)"One or more root rich client application context paths must be provided");
        this.startupContext = this.loadStartupContext(startupContextPath);
        if (this.startupContext != null) {
            this.displaySplashScreen((BeanFactory)this.startupContext);
        }
        try {
            this.setRootApplicationContext(this.loadRootApplicationContext(rootContextConfigLocations, (MessageSource)this.startupContext));
            this.launchMyRichClient();
        }
        finally {
            this.destroySplashScreen();
        }
    }

    public ApplicationLauncher(ApplicationContext rootApplicationContext) {
        this(null, rootApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationLauncher(String startupContextPath, ApplicationContext rootApplicationContext) {
        this.startupContext = this.loadStartupContext(startupContextPath);
        if (this.startupContext != null) {
            this.displaySplashScreen((BeanFactory)this.startupContext);
        }
        try {
            this.setRootApplicationContext(rootApplicationContext);
            this.launchMyRichClient();
        }
        finally {
            this.destroySplashScreen();
        }
    }

    private ApplicationContext loadStartupContext(String startupContextPath) {
        if (StringUtils.hasText((String)startupContextPath)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loading startup context from classpath resource [" + startupContextPath + "]"));
            }
            return new ClassPathXmlApplicationContext(startupContextPath);
        }
        return null;
    }

    private ApplicationContext loadRootApplicationContext(String[] configLocations, MessageSource messageSource) {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(configLocations, false);
        if (this.splashScreen instanceof MonitoringSplashScreen) {
            ProgressMonitor tracker = ((MonitoringSplashScreen)this.splashScreen).getProgressMonitor();
            applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new ProgressMonitoringBeanFactoryPostProcessor(tracker, messageSource));
        }
        applicationContext.refresh();
        return applicationContext;
    }

    private void setRootApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"The root rich client application context is required");
        this.rootApplicationContext = context;
    }

    private void launchMyRichClient() {
        Application application;
        if (this.startupContext == null) {
            this.displaySplashScreen((BeanFactory)this.rootApplicationContext);
        }
        try {
            application = (Application)this.rootApplicationContext.getBean(APPLICATION_BEAN_ID, Application.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException("A single bean definition with id application, of type " + Application.class.getName() + " must be defined in the main application context", e);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    application.start();
                }
            });
        }
        catch (InterruptedException e) {
            this.logger.warn((Object)"Application start interrupted", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new IllegalStateException("Application start thrown an exception: " + cause.getMessage(), cause);
        }
        this.logger.debug((Object)"Launcher thread exiting...");
    }

    private void displaySplashScreen(BeanFactory beanFactory) {
        if (beanFactory.containsBean(SPLASH_SCREEN_BEAN_ID)) {
            this.splashScreen = (SplashScreen)beanFactory.getBean(SPLASH_SCREEN_BEAN_ID, SplashScreen.class);
            this.logger.debug((Object)"Displaying application splash screen...");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ApplicationLauncher.this.splashScreen.splash();
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("EDT threading issue while showing splash screen", e);
            }
        } else {
            this.logger.info((Object)"No splash screen bean found to display. Continuing...");
        }
    }

    private void destroySplashScreen() {
        if (this.splashScreen != null) {
            this.logger.debug((Object)"Closing splash screen...");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ApplicationLauncher.this.splashScreen.dispose();
                    ApplicationLauncher.this.splashScreen = null;
                }
            });
        }
    }
}

