/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.binding.convert.ConversionContext;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.AbstractConverter;
import org.springframework.binding.convert.support.AbstractFormattingConverter;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.format.FormatterFactory;
import org.springframework.binding.format.support.StrictNumberFormatterFactory;
import org.springframework.richclient.convert.support.CollectionConverter;
import org.springframework.richclient.convert.support.ListModelConverter;
import org.springframework.util.StringUtils;

public class DefaultConversionServiceFactoryBean
implements FactoryBean {
    private ConversionService conversionService;
    private FormatterFactory formatterFactory = new StrictNumberFormatterFactory();

    protected FormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public void setFormatterFactory(FormatterFactory formatterFactory) {
        this.formatterFactory = formatterFactory;
    }

    public Object getObject() throws Exception {
        return this.getConversionService();
    }

    public Class getObjectType() {
        return ConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public final ConversionService getConversionService() {
        if (this.conversionService == null) {
            this.conversionService = this.createConversionService();
        }
        return this.conversionService;
    }

    protected ConversionService createConversionService() {
        DefaultConversionService service = new DefaultConversionService();
        service.addConverter((Converter)new TextToDate(this.getFormatterFactory(), true));
        service.addConverter((Converter)new DateToText(this.getFormatterFactory(), true));
        service.addConverter((Converter)new TextToNumber(this.getFormatterFactory(), true));
        service.addConverter((Converter)new NumberToText(this.getFormatterFactory(), true));
        service.addConverter((Converter)new BooleanToText());
        service.addConverter((Converter)new TextToBoolean());
        service.addConverter((Converter)new CollectionConverter());
        service.addConverter((Converter)new ListModelConverter());
        return service;
    }

    static final class BooleanToText
    extends AbstractConverter {
        public static final String VALUE_YES = "yes";
        public static final String VALUE_NO = "no";
        private String trueString;
        private String falseString;

        public BooleanToText() {
        }

        public BooleanToText(String trueString, String falseString) {
            this.trueString = trueString;
            this.falseString = falseString;
        }

        public Class[] getSourceClasses() {
            return new Class[]{Boolean.class};
        }

        public Class[] getTargetClasses() {
            return new Class[]{String.class};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            Boolean bool = (Boolean)source;
            if (this.trueString != null && bool.booleanValue()) {
                return this.trueString;
            }
            if (this.falseString != null && !bool.booleanValue()) {
                return this.falseString;
            }
            if (bool.booleanValue()) {
                return VALUE_YES;
            }
            return VALUE_NO;
        }
    }

    static final class TextToBoolean
    extends AbstractConverter {
        public static final String VALUE_TRUE = "true";
        public static final String VALUE_FALSE = "false";
        public static final String VALUE_ON = "on";
        public static final String VALUE_OFF = "off";
        public static final String VALUE_YES = "yes";
        public static final String VALUE_NO = "no";
        public static final String VALUE_1 = "1";
        public static final String VALUE_0 = "0";
        private String trueString;
        private String falseString;

        public TextToBoolean() {
        }

        public TextToBoolean(String trueString, String falseString) {
            this.trueString = trueString;
            this.falseString = falseString;
        }

        public Class[] getSourceClasses() {
            return new Class[]{String.class};
        }

        public Class[] getTargetClasses() {
            return new Class[]{Boolean.class};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            String text = (String)source;
            if (!StringUtils.hasText((String)text)) {
                return null;
            }
            if (this.trueString != null && text.equalsIgnoreCase(this.trueString)) {
                return Boolean.TRUE;
            }
            if (this.falseString != null && text.equalsIgnoreCase(this.falseString)) {
                return Boolean.FALSE;
            }
            if (this.trueString == null && (text.equalsIgnoreCase(VALUE_TRUE) || text.equalsIgnoreCase(VALUE_ON) || text.equalsIgnoreCase(VALUE_YES) || text.equals(VALUE_1))) {
                return Boolean.TRUE;
            }
            if (this.falseString == null && (text.equalsIgnoreCase(VALUE_FALSE) || text.equalsIgnoreCase(VALUE_OFF) || text.equalsIgnoreCase(VALUE_NO) || text.equals(VALUE_0))) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
        }
    }

    static final class NumberToText
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected NumberToText(FormatterFactory formatterLocator, boolean allowEmpty) {
            super(formatterLocator);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class};
        }

        public Class[] getTargetClasses() {
            return new Class[]{String.class};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || source != null ? this.getFormatterFactory().getNumberFormatter(source.getClass()).formatValue(source) : "";
        }
    }

    static final class TextToNumber
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected TextToNumber(FormatterFactory formatterLocator, boolean allowEmpty) {
            super(formatterLocator);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{String.class};
        }

        public Class[] getTargetClasses() {
            return new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || StringUtils.hasText((String)((String)source)) ? this.getFormatterFactory().getNumberFormatter(targetClass).parseValue((String)source, targetClass) : null;
        }
    }

    static final class DateToText
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected DateToText(FormatterFactory formatterLocator, boolean allowEmpty) {
            super(formatterLocator);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{Date.class};
        }

        public Class[] getTargetClasses() {
            return new Class[]{String.class};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || source != null ? this.getFormatterFactory().getDateTimeFormatter().formatValue(source) : "";
        }
    }

    static final class TextToDate
    extends AbstractFormattingConverter {
        private final boolean allowEmpty;

        protected TextToDate(FormatterFactory formatterFactory, boolean allowEmpty) {
            super(formatterFactory);
            this.allowEmpty = allowEmpty;
        }

        public Class[] getSourceClasses() {
            return new Class[]{String.class};
        }

        public Class[] getTargetClasses() {
            return new Class[]{Date.class};
        }

        protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
            return !this.allowEmpty || StringUtils.hasText((String)((String)source)) ? this.getFormatterFactory().getDateTimeFormatter().parseValue((String)source, Date.class) : null;
        }
    }
}

