/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.springframework.binding.value.PropertyChangePublisher;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.util.Assert;

public class WindowManager
extends Observable
implements PropertyChangePublisher {
    private List windows = new ArrayList();
    private WindowManager parentManager;
    private List subManagers;
    private ApplicationWindow activeWindow;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public WindowManager() {
    }

    public WindowManager(WindowManager parent) {
        Assert.notNull((Object)parent);
        parent.addWindowManager(this);
    }

    public void add(ApplicationWindow window) {
        if (this.activeWindow == null) {
            this.setActiveWindow(window);
        }
        if (!this.windows.contains(window)) {
            this.windows.add(window);
            window.setWindowManager(this);
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void addWindowManager(WindowManager wm) {
        if (this.subManagers == null) {
            this.subManagers = new ArrayList();
        }
        if (!this.subManagers.contains(wm)) {
            this.subManagers.add(wm);
            wm.parentManager = this;
        }
    }

    public boolean close() {
        List t = (List)((ArrayList)this.windows).clone();
        for (ApplicationWindow window : t) {
            if (window.close()) continue;
            return false;
        }
        if (this.subManagers != null) {
            for (WindowManager wm : this.subManagers) {
                if (wm.close()) continue;
                return false;
            }
        }
        return true;
    }

    public ApplicationWindow[] getWindows() {
        ApplicationWindow[] managed = new ApplicationWindow[this.windows.size()];
        this.windows.toArray(managed);
        return managed;
    }

    public WindowManager getParent() {
        return this.parentManager;
    }

    public final void remove(ApplicationWindow window) {
        if (this.windows.contains(window)) {
            this.windows.remove(window);
            window.setWindowManager(null);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public final void setActiveWindow(ApplicationWindow window) {
        ApplicationWindow old = this.activeWindow;
        this.activeWindow = window;
        if (this.getParent() != null) {
            this.getParent().setActiveWindow(window);
        }
        this.getChangeSupport().firePropertyChange("activeWindow", old, window);
    }

    public final ApplicationWindow getActiveWindow() {
        return this.activeWindow;
    }

    public int size() {
        return this.windows.size();
    }

    protected PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(propertyName, listener);
    }
}

