/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.mdi;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.springframework.richclient.application.mdi.ScrollingDesktopPane;

public class ScrollingDesktopManager
extends DefaultDesktopManager {
    private ScrollingDesktopPane desktopPane;

    public ScrollingDesktopManager(ScrollingDesktopPane pane) {
        this.desktopPane = pane;
    }

    public void endResizingFrame(JComponent f) {
        super.endResizingFrame(f);
        this.resizeDesktop();
    }

    public void endDraggingFrame(JComponent f) {
        super.endDraggingFrame(f);
        this.resizeDesktop();
    }

    public void setNormalSize() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            int x = 0;
            int y = 0;
            Insets scrollInsets = this.getInsets(scrollPane);
            Dimension d = scrollPane.getVisibleRect().getSize();
            if (scrollPane.getBorder() != null) {
                d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
            }
            d.setSize(d.getWidth() - 20.0, d.getHeight() - 20.0);
            this.setAllSize(x, y);
            scrollPane.invalidate();
            scrollPane.validate();
        }
    }

    private Insets getInsets(JScrollPane scrollPane) {
        if (scrollPane == null) {
            return new Insets(0, 0, 0, 0);
        }
        return scrollPane.getBorder().getBorderInsets(scrollPane);
    }

    private JScrollPane getScrollPane() {
        JViewport viewPort;
        if (this.desktopPane.getParent() instanceof JViewport && (viewPort = (JViewport)this.desktopPane.getParent()).getParent() instanceof JScrollPane) {
            return (JScrollPane)viewPort.getParent();
        }
        return null;
    }

    void resizeDesktop() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            int x = 0;
            int y = 0;
            Insets scrollInsets = this.getInsets(scrollPane);
            JInternalFrame[] allFrames = this.desktopPane.getAllFrames();
            for (int i = 0; i < allFrames.length; ++i) {
                if (allFrames[i].getX() + allFrames[i].getWidth() > x) {
                    x = allFrames[i].getX() + allFrames[i].getWidth();
                }
                if (allFrames[i].getY() + allFrames[i].getHeight() <= y) continue;
                y = allFrames[i].getY() + allFrames[i].getHeight();
            }
            Dimension d = scrollPane.getVisibleRect().getSize();
            if (scrollPane.getBorder() != null) {
                d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
            }
            if ((double)x <= d.getWidth()) {
                x = (int)d.getWidth() - 20;
            }
            if ((double)y <= d.getHeight()) {
                y = (int)d.getHeight() - 20;
            }
            this.setAllSize(x, y);
            scrollPane.invalidate();
            scrollPane.validate();
        }
    }

    private void setAllSize(int width, int height) {
        Dimension d = new Dimension(width, height);
        this.desktopPane.setMinimumSize(d);
        this.desktopPane.setMaximumSize(d);
        this.desktopPane.setPreferredSize(d);
    }
}

