/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.session;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.value.support.PropertyChangeSupport;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.session.ApplicationSessionInitializer;
import org.springframework.richclient.security.LoginEvent;
import org.springframework.richclient.security.LogoutEvent;
import org.springframework.security.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationSession
implements ApplicationListener {
    private static final ApplicationSession INSTANCE = new ApplicationSession();
    private ApplicationSessionInitializer applicationSessionInitializer;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String USER = "user";
    public static final String USER_ATTRIBUTES = "userAttributes";
    public static final String SESSION_ATTRIBUTES = "sessionAttributes";
    private Map<String, Object> userAttributes = new HashMap<String, Object>();
    private Map<String, Object> sessionAttributes = new HashMap<String, Object>();

    private ApplicationSession() {
    }

    public static ApplicationSession getSession() {
        return INSTANCE;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof LoginEvent && event.getSource() != LoginEvent.NO_AUTHENTICATION) {
            this.handleLoginEvent((LoginEvent)event);
        } else if (event instanceof LogoutEvent) {
            this.handleLogoutEvent((LogoutEvent)event);
        }
    }

    protected void handleLoginEvent(LoginEvent event) {
        ApplicationSessionInitializer asi = this.getApplicationSessionInitializer();
        if (asi != null) {
            asi.initializeUser();
            Map<String, Object> userAttributes = asi.getUserAttributes();
            if (userAttributes != null) {
                this.setUserAttributes(userAttributes);
            }
        }
        Authentication auth = (Authentication)event.getSource();
        this.propertyChangeSupport.firePropertyChange(USER, null, auth);
    }

    protected void handleLogoutEvent(LogoutEvent event) {
        this.clearUser();
        Authentication auth = (Authentication)event.getSource();
        this.propertyChangeSupport.firePropertyChange(USER, auth, null);
    }

    public void setApplicationSessionInitializer(ApplicationSessionInitializer applicationSessionInitializer) {
        this.applicationSessionInitializer = applicationSessionInitializer;
    }

    public ApplicationSessionInitializer getApplicationSessionInitializer() {
        if (this.applicationSessionInitializer == null) {
            this.applicationSessionInitializer = Application.instance().getLifecycleAdvisor().getApplicationSessionInitializer();
        }
        return this.applicationSessionInitializer;
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    public void initializeSession() {
        ApplicationSessionInitializer asi = this.getApplicationSessionInitializer();
        if (asi != null) {
            asi.initializeSession();
            Map<String, Object> sessionAttributes = asi.getSessionAttributes();
            if (sessionAttributes != null) {
                this.setSessionAttributes(sessionAttributes);
            }
            this.propertyChangeSupport.firePropertyChange(SESSION_ATTRIBUTES, null, sessionAttributes);
        }
    }

    public Object getUserAttribute(String key) {
        return this.getUserAttribute(key, null);
    }

    public Object getUserAttribute(String key, Object defaultValue) {
        Object attributeValue = this.userAttributes.get(key);
        if (attributeValue == null) {
            attributeValue = defaultValue;
        }
        return attributeValue;
    }

    public void setUserAttribute(String key, Object newValue) {
        Object oldValue = this.userAttributes.put(key, newValue);
        this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange(USER_ATTRIBUTES, null, this.userAttributes);
    }

    public void setUserAttributes(Map<String, Object> attributes) {
        this.userAttributes.putAll(attributes);
        this.propertyChangeSupport.firePropertyChange(USER_ATTRIBUTES, null, this.userAttributes);
    }

    public void clearUser() {
        this.userAttributes.clear();
        this.propertyChangeSupport.firePropertyChange(USER_ATTRIBUTES, null, null);
    }

    public Object getSessionAttribute(String key) {
        return this.getSessionAttribute(key, null);
    }

    public Object getSessionAttribute(String key, Object defaultValue) {
        Object attributeValue = this.sessionAttributes.get(key);
        if (attributeValue == null) {
            attributeValue = defaultValue;
        }
        return attributeValue;
    }

    public void setSessionAttribute(String key, Object newValue) {
        Object oldValue = this.sessionAttributes.put(key, newValue);
        this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange(SESSION_ATTRIBUTES, null, this.sessionAttributes);
    }

    public void setSessionAttributes(Map<String, Object> attributes) {
        this.sessionAttributes.putAll(attributes);
        this.propertyChangeSupport.firePropertyChange(SESSION_ATTRIBUTES, null, this.sessionAttributes);
    }

    public void clearSession() {
        this.sessionAttributes.clear();
        this.propertyChangeSupport.firePropertyChange(SESSION_ATTRIBUTES, null, this.sessionAttributes);
    }

    public Object getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public Object getAttribute(String key, Object defaultValue) {
        Object attributeValue = this.getUserAttribute(key, null);
        if (attributeValue != null) {
            return attributeValue;
        }
        attributeValue = this.getSessionAttribute(key, null);
        if (attributeValue != null) {
            return attributeValue;
        }
        return defaultValue;
    }
}

