/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.setup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.components.GradientPanel;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.wizard.Wizard;
import org.springframework.richclient.wizard.WizardDialog;
import org.springframework.richclient.wizard.WizardPage;

public class SetupWizardDialog
extends WizardDialog {
    private Container pageControlBackup;
    private GradientPanel firstPageControl;
    private ActionCommand nextCommand;

    public SetupWizardDialog(Wizard wizard) {
        super(wizard);
        this.setTitle(this.getApplicationName());
        this.setResizable(false);
    }

    protected JComponent createDialogContentPane() {
        this.createFirstPageControl();
        return super.createDialogContentPane();
    }

    protected JComponent createFirstPageControl() {
        this.firstPageControl = new GradientPanel();
        this.firstPageControl.setLayout(new BorderLayout());
        this.firstPageControl.add((Component)this.createFirstPageButtonBar(), "South");
        return this.firstPageControl;
    }

    protected JComponent createFirstPageButtonBar() {
        CommandGroup dialogCommandGroup = CommandGroup.createCommandGroup(null, this.getIntroPageCommandGroupMembers());
        JComponent buttonBar = dialogCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder(buttonBar);
        buttonBar.setOpaque(false);
        return buttonBar;
    }

    protected Object[] getIntroPageCommandGroupMembers() {
        this.nextCommand = new ActionCommand("nextCommand"){

            public void doExecuteCommand() {
                SetupWizardDialog.this.onNext();
            }
        };
        return new AbstractCommand[]{this.nextCommand, this.getCancelCommand()};
    }

    public void showPage(WizardPage page) {
        if (page.getPreviousPage() == null) {
            super.showPage(page);
            this.pageControlBackup = this.getDialogContentPane();
            this.firstPageControl.add((Component)page.getControl(), "Center");
            this.getDialog().setContentPane(this.firstPageControl);
        } else {
            if (this.pageControlBackup != null) {
                this.getDialog().setContentPane(this.pageControlBackup);
                this.pageControlBackup = null;
            }
            super.showPage(page);
        }
    }
}

