/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.springframework.core.io.Resource;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationDescriptor;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.CloseAction;
import org.springframework.richclient.text.HtmlPane;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class AboutBox {
    private Resource aboutTextPath;

    public void setAboutTextPath(Resource path) {
        this.aboutTextPath = path;
    }

    public Resource getAboutTextPath() {
        return this.aboutTextPath;
    }

    public void display(Window parent) {
        AboutDialog aboutMainDialog = new AboutDialog();
        aboutMainDialog.setParentComponent(parent);
        aboutMainDialog.showDialog();
    }

    protected static class HtmlScroller
    extends JViewport
    implements HyperlinkListener {
        private HtmlPane htmlPane;
        private Timer timer;
        private int initalDelay;
        private double incY = 0.0;
        private double currentY = 0.0;
        private double currentX = 0.0;

        public HtmlScroller(boolean antiAlias, int initalDelay, int speedPixSec, int fps) {
            this.initalDelay = initalDelay;
            this.incY = (double)speedPixSec / (double)fps;
            this.htmlPane = new HtmlPane();
            this.htmlPane.setAntiAlias(antiAlias);
            this.htmlPane.addHyperlinkListener(this);
            this.setView(this.htmlPane);
            this.timer = new Timer(1000 / fps, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int maxY = HtmlScroller.this.htmlPane.getHeight() - HtmlScroller.this.getHeight();
                    HtmlScroller.this.currentY = Math.max(0.0, Math.min(HtmlScroller.this.currentY + HtmlScroller.this.incY, (double)maxY));
                    if (HtmlScroller.this.currentY <= 0.0 || HtmlScroller.this.currentY == (double)maxY) {
                        HtmlScroller.this.pauseScrolling();
                    }
                    HtmlScroller.this.setViewPositionInternal(new Point((int)HtmlScroller.this.currentX, (int)HtmlScroller.this.currentY));
                }
            });
            this.reset();
        }

        public void setHtml(String html) {
            this.htmlPane.setText(html);
            this.setPreferredSize(this.htmlPane.getPreferredSize());
        }

        public final void reset() {
            this.currentX = 0.0;
            this.currentY = 0.0;
            this.timer.setInitialDelay(this.initalDelay);
            this.setViewPositionInternal(new Point((int)this.currentX, (int)this.currentY));
        }

        public void startScrolling() {
            this.timer.start();
        }

        public void pauseScrolling() {
            this.timer.stop();
            this.timer.setInitialDelay(0);
        }

        public void setViewPosition(Point p) {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
                this.enteredLink();
            } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
                this.exitedLink();
            }
        }

        private void setViewPositionInternal(Point p) {
            super.setViewPosition(p);
        }

        private void enteredLink() {
            this.pauseScrolling();
        }

        private void exitedLink() {
            this.startScrolling();
        }
    }

    protected class AboutDialog
    extends ApplicationDialog {
        private HtmlScroller scroller;

        public AboutDialog() {
            this.setTitle("About " + this.getApplicationName());
            this.setResizable(false);
            this.setCloseAction(CloseAction.DISPOSE);
        }

        protected void addDialogComponents() {
            JComponent dialogContentPane = this.createDialogContentPane();
            this.getDialogContentPane().add(dialogContentPane);
            this.getDialogContentPane().add((Component)this.createButtonBar(), "South");
        }

        protected JComponent createApplicationDescriptorComponent() {
            JTextArea txtDescriptor = this.getComponentFactory().createTextAreaAsLabel();
            txtDescriptor.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
            ApplicationDescriptor appDesc = Application.instance().getDescriptor();
            if (appDesc != null) {
                String displayName = appDesc.getDisplayName();
                String caption = appDesc.getCaption();
                String description = appDesc.getDescription();
                String version = appDesc.getVersion();
                String buildId = appDesc.getBuildId();
                StringBuffer sb = new StringBuffer();
                if (StringUtils.hasText((String)displayName)) {
                    sb.append(displayName).append("\n");
                }
                if (StringUtils.hasText((String)caption)) {
                    sb.append(caption).append("\n\n");
                }
                if (StringUtils.hasText((String)description)) {
                    sb.append(description).append("\n\n");
                }
                if (StringUtils.hasText((String)version)) {
                    sb.append(this.getMessage("aboutBox.version.label")).append(": ").append(version).append("\n");
                }
                if (StringUtils.hasText((String)buildId)) {
                    sb.append(this.getMessage("aboutBox.buildId.label")).append(": ").append(buildId).append("\n");
                }
                txtDescriptor.setText(sb.toString());
            }
            return txtDescriptor;
        }

        protected JComponent createDialogContentPane() {
            JPanel dialogPanel = new JPanel(new BorderLayout());
            dialogPanel.add((Component)this.createApplicationDescriptorComponent(), "North");
            if (AboutBox.this.aboutTextPath != null) {
                try {
                    this.scroller = new HtmlScroller(false, 2000, 15, 10);
                    String text = FileCopyUtils.copyToString((Reader)new BufferedReader(new InputStreamReader(AboutBox.this.aboutTextPath.getInputStream())));
                    this.scroller.setHtml(text);
                }
                catch (IOException e) {
                    IllegalStateException exp = new IllegalStateException("About text not accessible: " + e.getMessage());
                    exp.setStackTrace(e.getStackTrace());
                    throw exp;
                }
                dialogPanel.add(this.scroller);
                dialogPanel.setPreferredSize(new Dimension(this.scroller.getPreferredSize().width, 300));
            } else {
                dialogPanel.setPreferredSize(new Dimension(300, 200));
            }
            dialogPanel.add((Component)new JSeparator(), "South");
            return dialogPanel;
        }

        protected void onAboutToShow() {
            if (this.scroller != null) {
                try {
                    String text = FileCopyUtils.copyToString((Reader)new BufferedReader(new InputStreamReader(AboutBox.this.aboutTextPath.getInputStream())));
                    this.scroller.setHtml(text);
                }
                catch (IOException e) {
                    IllegalStateException exp = new IllegalStateException("About text not accessible: " + e.getMessage());
                    exp.setStackTrace(e.getStackTrace());
                    throw exp;
                }
                this.scroller.reset();
                this.scroller.startScrolling();
            }
        }

        protected boolean onFinish() {
            if (this.scroller != null) {
                this.scroller.pauseScrolling();
            }
            return true;
        }

        protected Object[] getCommandGroupMembers() {
            return new AbstractCommand[]{this.getFinishCommand()};
        }

        protected HtmlScroller getHtmlScroller() {
            return this.scroller;
        }
    }
}

