/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.PageComponentDescriptor;
import org.springframework.richclient.application.PageComponentListener;
import org.springframework.richclient.application.PageComponentPane;
import org.springframework.richclient.application.PageComponentPaneFactory;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.View;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.ViewDescriptorRegistry;
import org.springframework.richclient.application.support.DefaultViewContext;
import org.springframework.richclient.application.support.SharedCommandTargeter;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.util.EventListenerListHelper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplicationPage
extends AbstractControlFactory
implements ApplicationPage {
    private final EventListenerListHelper pageComponentListeners = new EventListenerListHelper(PageComponentListener.class);
    private ViewDescriptorRegistry viewDescriptorRegistry;
    private PageComponentPaneFactory pageComponentPaneFactory;
    private final List<PageComponent> pageComponents = new ArrayList<PageComponent>();
    private PageComponent activeComponent;
    private SharedCommandTargeter sharedCommandTargeter;
    private PageDescriptor descriptor;
    private ApplicationWindow window;
    private boolean settingActiveComponent;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private PropertyChangeListener pageComponentUpdater = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof PageComponent) {
                AbstractApplicationPage.this.updatePageComponentProperties((PageComponent)evt.getSource());
            }
        }
    };

    public AbstractApplicationPage() {
    }

    public AbstractApplicationPage(ApplicationWindow window, PageDescriptor pageDescriptor) {
        this.setApplicationWindow(window);
        this.setDescriptor(pageDescriptor);
    }

    protected void updatePageComponentProperties(PageComponent pageComponent) {
    }

    protected PageComponent findPageComponent(String viewDescriptorId) {
        for (PageComponent component : this.pageComponents) {
            if (!component.getId().equals(viewDescriptorId)) continue;
            return component;
        }
        return null;
    }

    @Override
    public <T extends View> T getView(String id) {
        return (T)((View)this.findPageComponent(id));
    }

    @Override
    public void addPageComponentListener(PageComponentListener listener) {
        this.pageComponentListeners.add(listener);
    }

    @Override
    public void removePageComponentListener(PageComponentListener listener) {
        this.pageComponentListeners.remove(listener);
    }

    protected void fireOpened(PageComponent component) {
        component.componentOpened();
        this.pageComponentListeners.fire("componentOpened", component);
    }

    protected void fireFocusGained(PageComponent component) {
        component.componentFocusGained();
        this.pageComponentListeners.fire("componentFocusGained", component);
    }

    protected void setActiveComponent() {
        if (this.pageComponents.size() > 0) {
            this.setActiveComponent(this.pageComponents.get(0));
        }
    }

    protected ViewDescriptor getViewDescriptor(String viewDescriptorId) {
        return this.getViewDescriptorRegistry().getViewDescriptor(viewDescriptorId);
    }

    @Override
    public PageComponent getActiveComponent() {
        return this.activeComponent;
    }

    @Override
    public void setActiveComponent(PageComponent pageComponent) {
        if (!this.pageComponents.contains(pageComponent)) {
            return;
        }
        if (this.activeComponent == pageComponent || this.settingActiveComponent) {
            return;
        }
        this.settingActiveComponent = true;
        if (this.activeComponent != null) {
            this.fireFocusLost(this.activeComponent);
        }
        this.giveFocusTo(pageComponent);
        this.activeComponent = pageComponent;
        this.fireFocusGained(this.activeComponent);
        this.settingActiveComponent = false;
    }

    protected void fireFocusLost(PageComponent component) {
        component.componentFocusLost();
        this.pageComponentListeners.fire("componentFocusLost", component);
    }

    protected abstract void doAddPageComponent(PageComponent var1);

    protected abstract void doRemovePageComponent(PageComponent var1);

    protected abstract boolean giveFocusTo(PageComponent var1);

    protected PageComponentPane createPageComponentPane(PageComponent pageComponent) {
        return this.getPageComponentPaneFactory().createPageComponentPane(pageComponent);
    }

    protected void fireClosed(PageComponent component) {
        component.componentClosed();
        this.pageComponentListeners.fire("componentClosed", component);
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public ApplicationWindow getWindow() {
        return this.window;
    }

    @Override
    public boolean close(PageComponent pageComponent) {
        if (!pageComponent.canClose()) {
            return false;
        }
        if (!this.pageComponents.contains(pageComponent)) {
            return false;
        }
        if (pageComponent == this.activeComponent) {
            this.fireFocusLost(pageComponent);
            this.activeComponent = null;
        }
        this.doRemovePageComponent(pageComponent);
        this.pageComponents.remove(pageComponent);
        pageComponent.removePropertyChangeListener(this.pageComponentUpdater);
        if (pageComponent instanceof ApplicationListener && this.getApplicationEventMulticaster() != null) {
            this.getApplicationEventMulticaster().removeApplicationListener((ApplicationListener)pageComponent);
        }
        pageComponent.dispose();
        this.fireClosed(pageComponent);
        if (this.activeComponent == null) {
            this.setActiveComponent();
        }
        return true;
    }

    @Override
    public boolean close() {
        for (PageComponent component : new HashSet<PageComponent>(this.pageComponents)) {
            if (this.close(component)) continue;
            return false;
        }
        return true;
    }

    @Override
    public View showView(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        return this.showView(this.getViewDescriptor(id), false, null);
    }

    @Override
    public View showView(String id, Object input) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        return this.showView(this.getViewDescriptor(id), true, input);
    }

    private View showView(ViewDescriptor viewDescriptor, boolean setInput, Object input) {
        Assert.notNull((Object)viewDescriptor, (String)"viewDescriptor cannot be null");
        View view = (View)this.findPageComponent(viewDescriptor.getId());
        if (view == null) {
            view = (View)this.createPageComponent(viewDescriptor);
            if (setInput) {
                view.getControl();
                view.setInput(input);
            }
            this.addPageComponent(view);
        } else if (setInput) {
            view.setInput(input);
        }
        this.setActiveComponent(view);
        return view;
    }

    @Override
    public void openEditor(Object editorInput) {
    }

    @Override
    public boolean closeAllEditors() {
        return true;
    }

    protected void addPageComponent(PageComponent pageComponent) {
        this.pageComponents.add(pageComponent);
        this.doAddPageComponent(pageComponent);
        pageComponent.addPropertyChangeListener(this.pageComponentUpdater);
        this.fireOpened(pageComponent);
    }

    protected PageComponent createPageComponent(PageComponentDescriptor descriptor) {
        PageComponent pageComponent = descriptor.createPageComponent();
        pageComponent.setContext(new DefaultViewContext(this, this.createPageComponentPane(pageComponent)));
        if (pageComponent instanceof ApplicationListener && this.getApplicationEventMulticaster() != null) {
            this.getApplicationEventMulticaster().addApplicationListener((ApplicationListener)pageComponent);
        }
        return pageComponent;
    }

    @Override
    public List<PageComponent> getPageComponents() {
        return Collections.unmodifiableList(this.pageComponents);
    }

    public final void setApplicationWindow(ApplicationWindow window) {
        Assert.notNull((Object)window, (String)"The containing window is required");
        Assert.state((this.window == null ? 1 : 0) != 0, (String)"Page window already set: it should only be set once, during initialization");
        this.window = window;
        this.sharedCommandTargeter = new SharedCommandTargeter(window);
        this.addPageComponentListener(this.sharedCommandTargeter);
    }

    public final void setDescriptor(PageDescriptor descriptor) {
        Assert.notNull((Object)descriptor, (String)"The page's descriptor is required");
        Assert.state((this.descriptor == null ? 1 : 0) != 0, (String)"Page descriptor already set: it should only be set once, during initialization");
        this.descriptor = descriptor;
    }

    protected PageDescriptor getPageDescriptor() {
        return this.descriptor;
    }

    public ApplicationEventMulticaster getApplicationEventMulticaster() {
        if (this.applicationEventMulticaster == null && this.getApplicationContext() != null) {
            String beanName = "applicationEventMulticaster";
            if (this.getApplicationContext().containsBean("applicationEventMulticaster")) {
                this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getApplicationContext().getBean("applicationEventMulticaster");
            }
        }
        return this.applicationEventMulticaster;
    }

    public void setViewDescriptorRegistry(ViewDescriptorRegistry viewDescriptorRegistry) {
        this.viewDescriptorRegistry = viewDescriptorRegistry;
    }

    public ViewDescriptorRegistry getViewDescriptorRegistry() {
        if (this.viewDescriptorRegistry == null) {
            this.viewDescriptorRegistry = (ViewDescriptorRegistry)ApplicationServicesLocator.services().getService(ViewDescriptorRegistry.class);
        }
        return this.viewDescriptorRegistry;
    }

    public void setPageComponentPaneFactory(PageComponentPaneFactory pageComponentPaneFactory) {
        this.pageComponentPaneFactory = pageComponentPaneFactory;
    }

    public PageComponentPaneFactory getPageComponentPaneFactory() {
        if (this.pageComponentPaneFactory == null) {
            this.pageComponentPaneFactory = (PageComponentPaneFactory)ApplicationServicesLocator.services().getService(PageComponentPaneFactory.class);
        }
        return this.pageComponentPaneFactory;
    }
}

