/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.springframework.richclient.application.PageComponentContext;
import org.springframework.richclient.application.PageComponentDescriptor;
import org.springframework.richclient.application.View;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.command.CommandManager;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.util.Assert;

public abstract class AbstractView
extends AbstractControlFactory
implements View {
    private PageComponentDescriptor descriptor;
    private PageComponentContext context;

    public void setDescriptor(PageComponentDescriptor descriptor) {
        Assert.notNull((Object)descriptor, (String)"The view descriptor is required");
        Assert.state((this.descriptor == null ? 1 : 0) != 0, (String)"A view's descriptor may only be set once");
        this.descriptor = descriptor;
    }

    public final void setContext(PageComponentContext context) {
        Assert.notNull((Object)context, (String)"This view's page component context is required");
        Assert.state((this.context == null ? 1 : 0) != 0, (String)"A view's context may only be set once");
        this.context = context;
        this.registerLocalCommandExecutors(context);
    }

    public String getId() {
        return this.getDescriptor().getId();
    }

    public PageComponentDescriptor getDescriptor() {
        Assert.state((this.descriptor != null ? 1 : 0) != 0, (String)"View descriptor property is not set; it is required");
        return this.descriptor;
    }

    public PageComponentContext getContext() {
        return this.context;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentFocusGained() {
    }

    public void componentFocusLost() {
    }

    public String getCaption() {
        return this.getDescriptor().getCaption();
    }

    public String getDescription() {
        return this.getDescriptor().getDescription();
    }

    public String getDisplayName() {
        return this.getDescriptor().getDisplayName();
    }

    public Icon getIcon() {
        return this.getDescriptor().getIcon();
    }

    public Image getImage() {
        return this.getDescriptor().getImage();
    }

    protected final Window getWindowControl() {
        return this.getContext().getWindow().getControl();
    }

    protected final CommandManager getWindowCommandManager() {
        return this.context.getWindow().getCommandManager();
    }

    protected final StatusBar getStatusBar() {
        return this.context.getWindow().getStatusBar();
    }

    protected abstract JComponent createControl();

    protected void registerLocalCommandExecutors(PageComponentContext context) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getDescriptor().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getDescriptor().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getDescriptor().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getDescriptor().removePropertyChangeListener(propertyName, listener);
    }

    public void dispose() {
    }

    public boolean canClose() {
        return true;
    }

    public void close() {
        this.context.getPage().close(this);
    }

    public void setInput(Object input) {
    }
}

