/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.form.FieldFaceSource;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.support.MessageSourceFieldFaceSource;
import org.springframework.binding.value.ValueChangeDetector;
import org.springframework.binding.value.support.DefaultValueChangeDetector;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.context.support.ResourceMapFactoryBean;
import org.springframework.core.enums.LabeledEnumResolver;
import org.springframework.core.enums.StaticLabeledEnumResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.richclient.application.ApplicationPageFactory;
import org.springframework.richclient.application.ApplicationServices;
import org.springframework.richclient.application.ApplicationWindowFactory;
import org.springframework.richclient.application.DefaultConversionServiceFactoryBean;
import org.springframework.richclient.application.PageComponentPaneFactory;
import org.springframework.richclient.application.PageDescriptorRegistry;
import org.springframework.richclient.application.ServiceNotFoundException;
import org.springframework.richclient.application.ViewDescriptorRegistry;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.application.config.DefaultApplicationObjectConfigurer;
import org.springframework.richclient.application.support.BeanFactoryPageDescriptorRegistry;
import org.springframework.richclient.application.support.BeanFactoryViewDescriptorRegistry;
import org.springframework.richclient.application.support.DefaultApplicationPageFactory;
import org.springframework.richclient.application.support.DefaultApplicationWindowFactory;
import org.springframework.richclient.application.support.DefaultPageComponentPaneFactory;
import org.springframework.richclient.command.CommandServices;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.command.config.DefaultCommandConfigurer;
import org.springframework.richclient.command.support.DefaultCommandServices;
import org.springframework.richclient.factory.ButtonFactory;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.factory.DefaultButtonFactory;
import org.springframework.richclient.factory.DefaultComponentFactory;
import org.springframework.richclient.factory.DefaultMenuFactory;
import org.springframework.richclient.factory.MenuFactory;
import org.springframework.richclient.form.binding.BinderSelectionStrategy;
import org.springframework.richclient.form.binding.BindingFactoryProvider;
import org.springframework.richclient.form.binding.swing.SwingBinderSelectionStrategy;
import org.springframework.richclient.form.binding.swing.SwingBindingFactoryProvider;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.image.DefaultIconSource;
import org.springframework.richclient.image.DefaultImageSource;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.image.ImageSource;
import org.springframework.richclient.security.ApplicationSecurityManager;
import org.springframework.richclient.security.SecurityControllerManager;
import org.springframework.richclient.security.support.DefaultApplicationSecurityManager;
import org.springframework.richclient.security.support.DefaultSecurityControllerManager;
import org.springframework.richclient.util.Assert;
import org.springframework.rules.RulesSource;
import org.springframework.rules.reporting.DefaultMessageTranslatorFactory;
import org.springframework.rules.reporting.MessageTranslatorFactory;
import org.springframework.rules.support.DefaultRulesSource;
import org.springframework.util.ClassUtils;

public class DefaultApplicationServices
implements ApplicationServices,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(DefaultApplicationServices.class);
    private final Map services = Collections.synchronizedMap(new HashMap());
    private static final Map serviceImplBuilders = new HashMap();
    private ApplicationContext applicationContext;
    private String applicationObjectConfigurerBeanId;
    protected static final ImplBuilder applicationContextImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            return applicationServices.getApplicationContext();
        }
    };
    protected static final ImplBuilder menuFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: MenuFactory");
            return new DefaultMenuFactory();
        }
    };
    protected static final ImplBuilder buttonFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ButtonFactory");
            return new DefaultButtonFactory();
        }
    };
    protected static final ImplBuilder commandServicesImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: CommandServices");
            return new DefaultCommandServices();
        }
    };
    protected static final ImplBuilder componentFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ComponentFactory");
            return new DefaultComponentFactory();
        }
    };
    protected static final ImplBuilder formComponentInterceptorFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: FormComponentInterceptorFactory");
            return new FormComponentInterceptorFactory(){

                public FormComponentInterceptor getInterceptor(FormModel formModel) {
                    return null;
                }
            };
        }
    };
    protected static final ImplBuilder applicationObjectConfigurerImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            Object impl = null;
            String aocBeanId = applicationServices.applicationObjectConfigurerBeanId;
            if (aocBeanId != null) {
                try {
                    impl = applicationServices.getApplicationContext().getBean(aocBeanId, ApplicationObjectConfigurer.class);
                }
                catch (NoSuchBeanDefinitionException e) {
                    logger.info((Object)("No object configurer found in context under name '" + aocBeanId + "'; configuring defaults."));
                    impl = new DefaultApplicationObjectConfigurer((MessageSource)applicationServices.getService(MessageSource.class));
                }
            } else {
                logger.info((Object)"No object configurer bean Id has been set; configuring defaults.");
                impl = new DefaultApplicationObjectConfigurer((MessageSource)applicationServices.getService(MessageSource.class));
            }
            return impl;
        }
    };
    protected static final ImplBuilder commandConfigurerImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: CommandConfigurer");
            return new DefaultCommandConfigurer();
        }
    };
    protected static final ImplBuilder imageSourceImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ImageSource");
            try {
                ResourceMapFactoryBean imageResourcesFactory = new ResourceMapFactoryBean();
                imageResourcesFactory.setLocation((Resource)new ClassPathResource("org/springframework/richclient/image/images.properties"));
                imageResourcesFactory.afterPropertiesSet();
                return new DefaultImageSource((Map)imageResourcesFactory.getObject());
            }
            catch (IOException e) {
                return new DefaultImageSource(new HashMap());
            }
        }
    };
    protected static final ImplBuilder iconSourceImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: IconSource");
            return new DefaultIconSource();
        }
    };
    protected static final ImplBuilder rulesSourceImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: RulesSource");
            return new DefaultRulesSource();
        }
    };
    protected static final ImplBuilder conversionServiceImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ConversionService");
            return new DefaultConversionServiceFactoryBean().getConversionService();
        }
    };
    protected static final ImplBuilder binderSelectionStrategyImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: BinderSelectionStrategy");
            return new SwingBinderSelectionStrategy();
        }
    };
    protected static final ImplBuilder FieldFaceSourceImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: FieldFaceSource");
            return new MessageSourceFieldFaceSource();
        }
    };
    protected static final ImplBuilder bindingFactoryProviderImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: BindingFactoryProvider");
            return new SwingBindingFactoryProvider();
        }
    };
    protected static final ImplBuilder valueChangeDetectorImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ValueChangeDetector");
            return new DefaultValueChangeDetector();
        }
    };
    protected static final ImplBuilder applicationSecurityManagerImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ApplicationSecurityManager");
            return new DefaultApplicationSecurityManager(true);
        }
    };
    protected static final ImplBuilder SecurityControllerManagerImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: SecurityControllerManager");
            return new DefaultSecurityControllerManager();
        }
    };
    protected static final ImplBuilder viewDescriptorRegistryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ViewDescriptorRegistry");
            BeanFactoryViewDescriptorRegistry impl = new BeanFactoryViewDescriptorRegistry();
            impl.setApplicationContext(applicationServices.getApplicationContext());
            return impl;
        }
    };
    protected static final ImplBuilder pageDescriptorRegistryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: PageDescriptorRegistry");
            BeanFactoryPageDescriptorRegistry impl = new BeanFactoryPageDescriptorRegistry();
            impl.setApplicationContext(applicationServices.getApplicationContext());
            return impl;
        }
    };
    protected static final ImplBuilder messageTranslatorFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: MessageTranslatorFactory");
            DefaultMessageTranslatorFactory impl = new DefaultMessageTranslatorFactory();
            impl.setMessageSource((MessageSource)applicationServices.getApplicationContext());
            return impl;
        }
    };
    protected static final ImplBuilder labeledEnumResolverImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: LabeledEnumResolver");
            return new StaticLabeledEnumResolver();
        }
    };
    protected static final ImplBuilder messageSourceImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Using MessageSource from application context");
            ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
            messageSource.setBasename("org.springframework.richclient.application.messages");
            return messageSource;
        }
    };
    protected static final ImplBuilder messageSourceAccessorImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            return new MessageSourceAccessor((MessageSource)applicationServices.getService(MessageSource.class));
        }
    };
    protected static final ImplBuilder applicationWindowFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ApplicationWindowFactory");
            return new DefaultApplicationWindowFactory();
        }
    };
    protected static final ImplBuilder applicationPageFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: ApplicationPageFactory");
            return new DefaultApplicationPageFactory();
        }
    };
    protected static final ImplBuilder pageComponentPaneFactoryImplBuilder = new ImplBuilder(){

        public Object build(DefaultApplicationServices applicationServices) {
            logger.info((Object)"Creating default service impl: PageComponentPaneFactory");
            return new DefaultPageComponentPaneFactory();
        }
    };

    public DefaultApplicationServices() {
    }

    public DefaultApplicationServices(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = new GenericApplicationContext();
        }
        return this.applicationContext;
    }

    public synchronized Object getService(Class serviceType) {
        Assert.required(serviceType, "serviceType");
        Object service = this.services.get(serviceType);
        if (service == null) {
            service = this.getServiceForClassType(serviceType);
            if (service == null) {
                service = this.getDefaultImplementation(serviceType);
            }
            if (service != null) {
                this.services.put(serviceType, service);
            }
        } else if (service instanceof String) {
            service = this.getApplicationContext().getBean((String)service, serviceType);
            this.services.put(serviceType, service);
        }
        if (service == null) {
            throw new ServiceNotFoundException(serviceType);
        }
        return service;
    }

    public boolean containsService(Class serviceType) {
        Assert.required(serviceType, "serviceType");
        return this.services.containsKey(serviceType) || this.containsServiceForClassType(serviceType) || this.containsDefaultImplementation(serviceType);
    }

    public void setRegistryEntries(Map entryMap) {
        for (Map.Entry entry : entryMap.entrySet()) {
            Class serviceType = null;
            Object key = entry.getKey();
            if (key instanceof String) {
                try {
                    serviceType = Class.forName((String)key);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)"Unable to convert key to Class", (Throwable)e);
                }
            } else if (key instanceof Class) {
                serviceType = (Class)key;
            } else {
                logger.error((Object)("Invalid service entry key; must be String or Class, got: " + key.getClass()));
            }
            if (serviceType == null) continue;
            this.services.put(serviceType, entry.getValue());
        }
    }

    public void setApplicationObjectConfigurer(ApplicationObjectConfigurer applicationObjectConfigurer) {
        this.services.put(ApplicationObjectConfigurer.class, applicationObjectConfigurer);
    }

    public void setApplicationObjectConfigurerId(String applicationObjectConfigurerId) {
        this.services.put(ApplicationObjectConfigurer.class, applicationObjectConfigurerId);
    }

    public void setApplicationSecurityManager(ApplicationSecurityManager applicationSecurityManager) {
        this.services.put(ApplicationSecurityManager.class, applicationSecurityManager);
    }

    public void setApplicationSecurityManagerId(String applicationSecurityManagerId) {
        this.services.put(ApplicationSecurityManager.class, applicationSecurityManagerId);
    }

    public void setApplicationWindowFactory(ApplicationWindowFactory factory) {
        this.services.put(ApplicationWindowFactory.class, factory);
    }

    public void setApplicationWindowFactoryId(String factoryId) {
        this.services.put(ApplicationWindowFactory.class, factoryId);
    }

    public void setApplicationPageFactory(ApplicationPageFactory factory) {
        this.services.put(ApplicationPageFactory.class, factory);
    }

    public void setApplicationPageFactoryId(String factoryId) {
        this.services.put(ApplicationPageFactory.class, factoryId);
    }

    public void setPageComponentPaneFactory(PageComponentPaneFactory factory) {
        this.services.put(PageComponentPaneFactory.class, factory);
    }

    public void setPageComponentPaneFactoryId(String factoryId) {
        this.services.put(PageComponentPaneFactory.class, factoryId);
    }

    public void setBinderSelectionStrategy(BinderSelectionStrategy binderSelectionStrategy) {
        this.services.put(BinderSelectionStrategy.class, binderSelectionStrategy);
    }

    public void setBinderSelectionStrategyId(String binderSelectionStrategyId) {
        this.services.put(BinderSelectionStrategy.class, binderSelectionStrategyId);
    }

    public void setBindingFactoryProvider(BindingFactoryProvider bindingFactoryProvider) {
        this.services.put(BindingFactoryProvider.class, bindingFactoryProvider);
    }

    public void setBindingFactoryProviderId(String bindingFactoryProviderId) {
        this.services.put(BindingFactoryProvider.class, bindingFactoryProviderId);
    }

    public void setCommandServices(CommandServices commandServices) {
        this.services.put(CommandServices.class, commandServices);
    }

    public void setCommandServicesId(String commandServicesId) {
        this.services.put(CommandServices.class, commandServicesId);
    }

    public void setCommandConfigurer(CommandConfigurer commandConfigurer) {
        this.services.put(CommandConfigurer.class, commandConfigurer);
    }

    public void setCommandConfigurerId(String commandConfigurerId) {
        this.services.put(CommandConfigurer.class, commandConfigurerId);
    }

    public void setButtonFactory(ButtonFactory buttonFactory) {
        this.services.put(ButtonFactory.class, buttonFactory);
    }

    public void setButtonFactoryId(String buttonFactoryId) {
        this.services.put(ButtonFactory.class, buttonFactoryId);
    }

    public void setMenuFactory(MenuFactory menuFactory) {
        this.services.put(MenuFactory.class, menuFactory);
    }

    public void setMenuFactoryId(String menuFactoryId) {
        this.services.put(MenuFactory.class, menuFactoryId);
    }

    public void setComponentFactory(ComponentFactory componentFactory) {
        this.services.put(ComponentFactory.class, componentFactory);
    }

    public void setComponentFactoryId(String componentFactoryId) {
        this.services.put(ComponentFactory.class, componentFactoryId);
    }

    public void setConversionService(ConversionService conversionService) {
        this.services.put(ConversionService.class, conversionService);
    }

    public void setConversionServiceId(String conversionServiceId) {
        this.services.put(ConversionService.class, conversionServiceId);
    }

    public void setFormComponentInterceptorFactory(FormComponentInterceptorFactory formComponentInterceptorFactory) {
        this.services.put(FormComponentInterceptorFactory.class, formComponentInterceptorFactory);
    }

    public void setFormComponentInterceptorFactoryId(String formComponentInterceptorFactoryId) {
        this.services.put(FormComponentInterceptorFactory.class, formComponentInterceptorFactoryId);
    }

    public void setFieldFaceSource(FieldFaceSource fieldFaceSource) {
        this.services.put(FieldFaceSource.class, fieldFaceSource);
    }

    public void setFieldFaceSourceId(String fieldFaceSourceId) {
        this.services.put(FieldFaceSource.class, fieldFaceSourceId);
    }

    public void setIconSource(IconSource iconSource) {
        this.services.put(IconSource.class, iconSource);
    }

    public void setIconSourceId(String iconSourceId) {
        this.services.put(IconSource.class, iconSourceId);
    }

    public void setImageSource(ImageSource imageSource) {
        this.services.put(ImageSource.class, imageSource);
    }

    public void setImageSourceId(String imageSourceId) {
        this.services.put(ImageSource.class, imageSourceId);
    }

    public void setLabeledEnumResolver(LabeledEnumResolver labeledEnumResolver) {
        this.services.put(LabeledEnumResolver.class, labeledEnumResolver);
    }

    public void setLabeledEnumResolverId(String labeledEnumResolverId) {
        this.services.put(LabeledEnumResolver.class, labeledEnumResolverId);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.services.put(MessageSource.class, messageSource);
    }

    public void setMessageSourceId(String messageSourceId) {
        this.services.put(MessageSource.class, messageSourceId);
    }

    public void setMessageSourceAccesor(MessageSourceAccessor messageSourceAccessor) {
        this.services.put(MessageSourceAccessor.class, messageSourceAccessor);
    }

    public void setMessageSourceAccesorId(String messageSourceAccessorId) {
        this.services.put(MessageSourceAccessor.class, messageSourceAccessorId);
    }

    public void setRulesSource(RulesSource rulesSource) {
        this.services.put(RulesSource.class, rulesSource);
    }

    public void setRulesSourceId(String rulesSourceId) {
        this.services.put(RulesSource.class, rulesSourceId);
    }

    public void setSecurityControllerManager(SecurityControllerManager securityControllerManager) {
        this.services.put(SecurityControllerManager.class, securityControllerManager);
    }

    public void setSecurityControllerManagerId(String securityControllerManagerId) {
        this.services.put(SecurityControllerManager.class, securityControllerManagerId);
    }

    public void setValueChangeDetector(ValueChangeDetector valueChangeDetector) {
        this.services.put(ValueChangeDetector.class, valueChangeDetector);
    }

    public void setValueChangeDetectorId(String valueChangeDetectorId) {
        this.services.put(ValueChangeDetector.class, valueChangeDetectorId);
    }

    public void setViewDescriptorRegistry(ViewDescriptorRegistry viewDescriptorRegistry) {
        this.services.put(ViewDescriptorRegistry.class, viewDescriptorRegistry);
    }

    public void setPageDescriptorRegistry(PageDescriptorRegistry pageDescriptorRegistry) {
        this.services.put(PageDescriptorRegistry.class, pageDescriptorRegistry);
    }

    public void setMessageTranslatorFactory(MessageTranslatorFactory messageTranslatorFactory) {
        this.services.put(MessageTranslatorFactory.class, messageTranslatorFactory);
    }

    public void setMessageTranslatorFactoryId(String messageTranslatorFactoryId) {
        this.services.put(MessageTranslatorFactory.class, messageTranslatorFactoryId);
    }

    public void setViewDescriptorRegistryId(String viewDescriptorRegistryId) {
        this.services.put(ViewDescriptorRegistry.class, viewDescriptorRegistryId);
    }

    public void setPageDescriptorRegistryId(String pageDescriptorRegistryId) {
        this.services.put(PageDescriptorRegistry.class, pageDescriptorRegistryId);
    }

    protected Object getServiceForClassType(Class serviceType) {
        String lookupName = ClassUtils.getShortNameAsProperty((Class)serviceType);
        ApplicationContext ctx = this.getApplicationContext();
        if (ctx.containsBean(lookupName)) {
            Object bean = ctx.getBean(lookupName);
            if (serviceType.isAssignableFrom(bean.getClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using bean '" + lookupName + "' (" + bean.getClass().getName() + ") for service " + serviceType.getName()));
                }
                return bean;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bean with id '" + lookupName + "' (" + bean.getClass().getName() + ") does not implement " + serviceType.getName()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No Bean with id '" + lookupName + "' found for service " + serviceType.getName()));
        }
        return null;
    }

    protected Object getDefaultImplementation(Class serviceType) {
        Object impl = null;
        ImplBuilder builder = (ImplBuilder)serviceImplBuilders.get(serviceType);
        if (builder != null) {
            impl = builder.build(this);
        }
        return impl;
    }

    protected boolean containsServiceForClassType(Class serviceType) {
        return this.getApplicationContext().containsBean(ClassUtils.getShortNameAsProperty((Class)serviceType));
    }

    protected boolean containsDefaultImplementation(Class serviceType) {
        return serviceImplBuilders.containsKey(serviceType);
    }

    static {
        serviceImplBuilders.put(ApplicationContext.class, applicationContextImplBuilder);
        serviceImplBuilders.put(ApplicationObjectConfigurer.class, applicationObjectConfigurerImplBuilder);
        serviceImplBuilders.put(ApplicationSecurityManager.class, applicationSecurityManagerImplBuilder);
        serviceImplBuilders.put(ApplicationPageFactory.class, applicationPageFactoryImplBuilder);
        serviceImplBuilders.put(ApplicationWindowFactory.class, applicationWindowFactoryImplBuilder);
        serviceImplBuilders.put(PageComponentPaneFactory.class, pageComponentPaneFactoryImplBuilder);
        serviceImplBuilders.put(BinderSelectionStrategy.class, binderSelectionStrategyImplBuilder);
        serviceImplBuilders.put(BindingFactoryProvider.class, bindingFactoryProviderImplBuilder);
        serviceImplBuilders.put(ButtonFactory.class, buttonFactoryImplBuilder);
        serviceImplBuilders.put(MenuFactory.class, menuFactoryImplBuilder);
        serviceImplBuilders.put(CommandServices.class, commandServicesImplBuilder);
        serviceImplBuilders.put(CommandConfigurer.class, commandConfigurerImplBuilder);
        serviceImplBuilders.put(ComponentFactory.class, componentFactoryImplBuilder);
        serviceImplBuilders.put(ConversionService.class, conversionServiceImplBuilder);
        serviceImplBuilders.put(FormComponentInterceptorFactory.class, formComponentInterceptorFactoryImplBuilder);
        serviceImplBuilders.put(FieldFaceSource.class, FieldFaceSourceImplBuilder);
        serviceImplBuilders.put(IconSource.class, iconSourceImplBuilder);
        serviceImplBuilders.put(ImageSource.class, imageSourceImplBuilder);
        serviceImplBuilders.put(LabeledEnumResolver.class, labeledEnumResolverImplBuilder);
        serviceImplBuilders.put(MessageSource.class, messageSourceImplBuilder);
        serviceImplBuilders.put(MessageSourceAccessor.class, messageSourceAccessorImplBuilder);
        serviceImplBuilders.put(RulesSource.class, rulesSourceImplBuilder);
        serviceImplBuilders.put(SecurityControllerManager.class, SecurityControllerManagerImplBuilder);
        serviceImplBuilders.put(ValueChangeDetector.class, valueChangeDetectorImplBuilder);
        serviceImplBuilders.put(ViewDescriptorRegistry.class, viewDescriptorRegistryImplBuilder);
        serviceImplBuilders.put(PageDescriptorRegistry.class, pageDescriptorRegistryImplBuilder);
        serviceImplBuilders.put(MessageTranslatorFactory.class, messageTranslatorFactoryImplBuilder);
    }

    protected static interface ImplBuilder {
        public Object build(DefaultApplicationServices var1);
    }
}

