/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.awt.Dimension;
import java.awt.Image;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.config.ApplicationWindowConfigurer;
import org.springframework.util.Assert;

public class DefaultApplicationWindowConfigurer
implements ApplicationWindowConfigurer {
    private String title = "New Application Window";
    private Image image;
    private boolean showMenuBar = true;
    private boolean showToolBar = true;
    private boolean showStatusBar = true;
    private Dimension initialSize = new Dimension(800, 600);
    private ApplicationWindow window;

    public DefaultApplicationWindowConfigurer(ApplicationWindow window) {
        Assert.notNull((Object)window, (String)"Application window is required");
        this.window = window;
    }

    public ApplicationWindow getWindow() {
        return this.window;
    }

    public String getTitle() {
        return this.title;
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getInitialSize() {
        return this.initialSize;
    }

    public boolean getShowMenuBar() {
        return this.showMenuBar;
    }

    public boolean getShowToolBar() {
        return this.showToolBar;
    }

    public boolean getShowStatusBar() {
        return this.showStatusBar;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setInitialSize(Dimension initialSize) {
        if (initialSize != null) {
            this.initialSize = initialSize;
        }
    }

    public void setShowMenuBar(boolean showMenuBar) {
        this.showMenuBar = showMenuBar;
    }

    public void setShowToolBar(boolean showToolBar) {
        this.showToolBar = showToolBar;
    }

    public void setShowStatusBar(boolean showStatusBar) {
        this.showStatusBar = showStatusBar;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("title", (Object)this.title).append("image", (Object)this.image).append("showMenuBar", this.showMenuBar).append("showToolBar", this.showToolBar).append("showStatusBar", this.showStatusBar).append("initialSize", (Object)this.initialSize).append("window", (Object)this.window).toString();
    }
}

