/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.beans.PropertyEditor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.richclient.util.ClassUtils;
import org.springframework.util.Assert;

public class DefaultPropertyEditorRegistry {
    private static final Log logger = LogFactory.getLog(DefaultPropertyEditorRegistry.class);
    private Map propertyEditorByClass = new HashMap();
    private Map propertyEditorByClassAndProperty = new HashMap();

    public DefaultPropertyEditorRegistry() {
        this.initDefaultEditors();
    }

    protected void initDefaultEditors() {
        this.setPropertyEditor(Integer.TYPE, DefaultIntegerEditor.class);
        this.setPropertyEditor(Integer.class, DefaultIntegerEditor.class);
        this.setPropertyEditor(Long.TYPE, DefaultLongEditor.class);
        this.setPropertyEditor(Long.class, DefaultLongEditor.class);
        this.setPropertyEditor(Float.TYPE, DefaultFloatEditor.class);
        this.setPropertyEditor(Float.class, DefaultFloatEditor.class);
        this.setPropertyEditor(Double.TYPE, DefaultDoubleEditor.class);
        this.setPropertyEditor(Double.class, DefaultDoubleEditor.class);
        this.setPropertyEditor(BigDecimal.class, DefaultBigDecimalEditor.class);
        this.setPropertyEditor(Date.class, DefaultDateEditor.class);
    }

    public void setPropertyEditors(List propertyEditors) {
        Iterator i = propertyEditors.iterator();
        while (i.hasNext()) {
            this.setPropertyEditor((Properties)i.next());
        }
    }

    public void setPropertyEditor(Properties properties) {
        ClassEditor classEditor = new ClassEditor();
        Class objectClass = null;
        String propertyName = null;
        Class propertyEditorClass = null;
        if (properties.get("objectClass") != null) {
            classEditor.setAsText((String)properties.get("objectClass"));
            objectClass = (Class)classEditor.getValue();
        }
        propertyName = (String)properties.get("propertyName");
        if (properties.get("propertyEditorClass") == null) {
            throw new IllegalArgumentException("propertyEditorClass is required");
        }
        classEditor.setAsText((String)properties.get("propertyEditorClass"));
        propertyEditorClass = (Class)classEditor.getValue();
        if (propertyName != null) {
            this.setPropertyEditor(objectClass, propertyName, propertyEditorClass);
        } else if (objectClass != null) {
            this.setPropertyEditor(objectClass, propertyEditorClass);
        } else {
            throw new IllegalArgumentException("objectClass and/or propertyName are required");
        }
    }

    public void setPropertyEditor(Class typeClass, Class propertyEditorClass) {
        Assert.notNull((Object)typeClass);
        this.verifyPropertyEditorClass(propertyEditorClass);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting " + propertyEditorClass + " as the property editor for " + typeClass));
        }
        this.propertyEditorByClass.put(typeClass, propertyEditorClass);
    }

    private void verifyPropertyEditorClass(Class propertyEditorClass) {
        Assert.notNull((Object)propertyEditorClass);
        Assert.isTrue((boolean)PropertyEditor.class.isAssignableFrom(propertyEditorClass), (String)(propertyEditorClass + " is not a " + PropertyEditor.class));
        try {
            Assert.isTrue((boolean)Modifier.isPublic(propertyEditorClass.getConstructor(null).getModifiers()), (String)(propertyEditorClass + " does not have a public no-arg constructor"));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(propertyEditorClass + " does not have a no-arg constructor");
        }
    }

    public void setPropertyEditor(Class objectType, String propertyName, Class propertyEditorClass) {
        Assert.notNull((Object)objectType);
        Assert.notNull((Object)propertyName);
        Assert.isTrue((boolean)ClassUtils.isAProperty(objectType, propertyName), (String)("'" + propertyName + "' is not a property of " + objectType));
        this.verifyPropertyEditorClass(propertyEditorClass);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting " + propertyEditorClass + " as the property editor for the '" + propertyName + "' property of " + objectType));
        }
        ClassAndPropertyKey key = new ClassAndPropertyKey(objectType, propertyName);
        this.propertyEditorByClassAndProperty.put(key, propertyEditorClass);
    }

    public PropertyEditor getPropertyEditor(Class typeClass) {
        Class editorClass = (Class)ClassUtils.getValueFromMapForClass(typeClass, this.propertyEditorByClass);
        if (editorClass == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find a property editor for " + typeClass));
            }
            return null;
        }
        return DefaultPropertyEditorRegistry.instantiatePropertyEditor(editorClass);
    }

    public PropertyEditor getPropertyEditor(Class objectType, String propertyName) {
        ClassAndPropertyKey key = new ClassAndPropertyKey(objectType, propertyName);
        Class editorClass = (Class)this.propertyEditorByClassAndProperty.get(key);
        if (editorClass != null) {
            return DefaultPropertyEditorRegistry.instantiatePropertyEditor(editorClass);
        }
        Set keys = this.propertyEditorByClassAndProperty.keySet();
        HashMap map = new HashMap();
        for (ClassAndPropertyKey propertyKey : keys) {
            if (!propertyName.equals(propertyKey.getPropertyName())) continue;
            map.put(propertyKey.getTheClass(), this.propertyEditorByClassAndProperty.get(propertyKey));
        }
        editorClass = (Class)ClassUtils.getValueFromMapForClass(objectType, map);
        if (editorClass != null) {
            this.setPropertyEditor(objectType, propertyName, editorClass);
            return DefaultPropertyEditorRegistry.instantiatePropertyEditor(editorClass);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not find a property editor for the " + propertyName + " property of " + objectType + ", so looking for it by class type"));
        }
        Class propertyClass = ClassUtils.getPropertyClass(objectType, propertyName);
        return this.getPropertyEditor(propertyClass);
    }

    private static PropertyEditor instantiatePropertyEditor(Class propEdClass) {
        try {
            return (PropertyEditor)propEdClass.newInstance();
        }
        catch (InstantiationException e) {
            IllegalStateException exp = new IllegalStateException("Could not instantiate " + propEdClass);
            exp.initCause(e);
            throw exp;
        }
        catch (IllegalAccessException e) {
            IllegalStateException exp = new IllegalStateException("Could not instantiate " + propEdClass);
            exp.initCause(e);
            throw exp;
        }
    }

    private static class ClassAndPropertyKey {
        private Class theClass;
        private String propertyName;

        public ClassAndPropertyKey(Class theClass, String propertyName) {
            if (theClass == null || propertyName == null) {
                throw new NullPointerException();
            }
            this.propertyName = propertyName;
            this.theClass = theClass;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class getTheClass() {
            return this.theClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassAndPropertyKey)) {
                return false;
            }
            ClassAndPropertyKey classAndPropertyKey = (ClassAndPropertyKey)o;
            if (this.propertyName != null ? !this.propertyName.equals(classAndPropertyKey.propertyName) : classAndPropertyKey.propertyName != null) {
                return false;
            }
            return !(this.theClass != null ? !this.theClass.equals(classAndPropertyKey.theClass) : classAndPropertyKey.theClass != null);
        }

        public int hashCode() {
            int result = this.theClass != null ? this.theClass.hashCode() : 0;
            result = 29 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
            return result;
        }
    }

    private static class DefaultDateEditor
    extends CustomDateEditor {
        public DefaultDateEditor() {
            super(DateFormat.getDateInstance(), true);
        }
    }

    private static class DefaultBooleanEditor
    extends CustomBooleanEditor {
        public DefaultBooleanEditor() {
            super(true);
        }
    }

    private static class DefaultBigDecimalEditor
    extends CustomNumberEditor {
        public DefaultBigDecimalEditor() {
            super(BigDecimal.class, true);
        }
    }

    private static class DefaultDoubleEditor
    extends CustomNumberEditor {
        public DefaultDoubleEditor() {
            super(Double.class, true);
        }
    }

    private static class DefaultFloatEditor
    extends CustomNumberEditor {
        public DefaultFloatEditor() {
            super(Float.class, true);
        }
    }

    private static class DefaultLongEditor
    extends CustomNumberEditor {
        public DefaultLongEditor() {
            super(Long.class, true);
        }
    }

    private static class DefaultIntegerEditor
    extends CustomNumberEditor {
        public DefaultIntegerEditor() {
            super(Integer.class, true);
        }
    }
}

