/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.View;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.command.support.ShowViewCommand;
import org.springframework.richclient.core.LabeledObjectSupport;
import org.springframework.util.Assert;

public class LookupViewDescriptor
extends LabeledObjectSupport
implements ViewDescriptor,
BeanNameAware,
BeanFactoryAware,
InitializingBean {
    private String id;
    private String viewPrototypeBeanName;
    private BeanFactory beanFactory;

    public void setId(String id) {
        Assert.notNull((Object)id);
        this.id = id;
    }

    public String getViewPrototypeBeanName() {
        return this.viewPrototypeBeanName;
    }

    public void setViewPrototypeBeanName(String viewPrototypeBeanName) {
        this.viewPrototypeBeanName = viewPrototypeBeanName;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected View createView() {
        View view = (View)this.getBeanFactory().getBean(this.getViewPrototypeBeanName(), View.class);
        view.setDescriptor(this);
        return view;
    }

    public String getId() {
        return this.id;
    }

    public ActionCommand createShowViewCommand(ApplicationWindow window) {
        return new ShowViewCommand(this, window);
    }

    public CommandButtonLabelInfo getShowViewCommandLabel() {
        return this.getLabel();
    }

    public PageComponent createPageComponent() {
        return this.createView();
    }

    public void setBeanName(String name) {
        this.setId(name);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public final void afterPropertiesSet() throws Exception {
        this.initViewDescriptor();
        if (this.getViewPrototypeBeanName() == null) {
            throw new IllegalArgumentException("viewPrototypeBeanName property must be set.");
        }
        if (this.getBeanFactory() == null) {
            throw new IllegalArgumentException("beanFactory property must be set.");
        }
        if (!this.getBeanFactory().containsBean(this.getViewPrototypeBeanName())) {
            throw new IllegalArgumentException("There is no bean in the bean factory with the given name '" + this.getViewPrototypeBeanName() + "'");
        }
        if (this.getBeanFactory().isSingleton(this.getViewPrototypeBeanName())) {
            throw new IllegalArgumentException("View bean '" + this.getViewPrototypeBeanName() + "' must be a prototype (singleton=\"false\").");
        }
        if (!View.class.isAssignableFrom(this.getBeanFactory().getType(this.getViewPrototypeBeanName()))) {
            throw new IllegalArgumentException("Prototype View bean '" + this.getViewPrototypeBeanName() + "' does not implement the View interface.");
        }
    }

    protected void initViewDescriptor() throws Exception {
    }
}

